/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlDelete;
import com.hazelcast.org.apache.calcite.sql.SqlJoin;
import com.hazelcast.org.apache.calcite.sql.SqlMerge;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.SqlUpdate;
import com.hazelcast.org.apache.calcite.sql.validate.ScopeChild;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorTable;
import java.util.Objects;
import org.apiguardian.api.API;

public class SqlNonNullableAccessors {
    private SqlNonNullableAccessors() {
    }

    private static String safeToString(Object obj) {
        try {
            return Objects.toString(obj);
        }
        catch (Throwable e) {
            return "Error in toString: " + e;
        }
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static SqlSelect getSourceSelect(SqlUpdate statement) {
        return Objects.requireNonNull(statement.getSourceSelect(), () -> "sourceSelect of " + SqlNonNullableAccessors.safeToString(statement));
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static SqlSelect getSourceSelect(SqlDelete statement) {
        return Objects.requireNonNull(statement.getSourceSelect(), () -> "sourceSelect of " + SqlNonNullableAccessors.safeToString(statement));
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static SqlSelect getSourceSelect(SqlMerge statement) {
        return Objects.requireNonNull(statement.getSourceSelect(), () -> "sourceSelect of " + SqlNonNullableAccessors.safeToString(statement));
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static SqlNode getCondition(SqlJoin join) {
        return Objects.requireNonNull(join.getCondition(), () -> "getCondition of " + SqlNonNullableAccessors.safeToString(join));
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    static SqlNode getNode(ScopeChild child) {
        return Objects.requireNonNull(child.namespace.getNode(), () -> "child.namespace.getNode() of " + child.name);
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static SqlNodeList getSelectList(SqlSelect innerSelect) {
        return Objects.requireNonNull(innerSelect.getSelectList(), () -> "selectList of " + SqlNonNullableAccessors.safeToString(innerSelect));
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static SqlValidatorTable getTable(SqlValidatorNamespace ns) {
        return Objects.requireNonNull(ns.getTable(), () -> "ns.getTable() for " + SqlNonNullableAccessors.safeToString(ns));
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static SqlValidatorScope getScope(SqlCallBinding callBinding) {
        return Objects.requireNonNull(callBinding.getScope(), () -> "scope is null for " + SqlNonNullableAccessors.safeToString(callBinding));
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static SqlValidatorNamespace getNamespace(SqlCallBinding callBinding) {
        return Objects.requireNonNull(callBinding.getValidator().getNamespace(callBinding.getCall()), () -> "scope is null for " + SqlNonNullableAccessors.safeToString(callBinding));
    }

    @API(since="1.27", status=API.Status.EXPERIMENTAL)
    public static <T> T getOperandLiteralValueOrThrow(SqlOperatorBinding opBinding, int ordinal, Class<T> clazz) {
        return Objects.requireNonNull(opBinding.getOperandLiteralValue(ordinal, clazz), () -> "expected non-null operand " + ordinal + " in " + SqlNonNullableAccessors.safeToString(opBinding));
    }
}

