/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeTransform;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeTransforms;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Static;
import java.util.List;
import java.util.Objects;

public class SqlMultisetQueryConstructor
extends SqlSpecialOperator {
    final SqlTypeTransform typeTransform;

    public SqlMultisetQueryConstructor() {
        this("MULTISET", SqlKind.MULTISET_QUERY_CONSTRUCTOR, SqlTypeTransforms.TO_MULTISET);
    }

    protected SqlMultisetQueryConstructor(String name, SqlKind kind, SqlTypeTransform typeTransform) {
        super(name, kind, 200, false, ReturnTypes.ARG0.andThen(typeTransform), null, OperandTypes.VARIADIC);
        this.typeTransform = typeTransform;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        List<RelDataType> argTypes = SqlTypeUtil.deriveType(callBinding, callBinding.operands());
        RelDataType componentType = callBinding.getTypeFactory().leastRestrictive(argTypes);
        if (null == componentType) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return false;
        }
        return true;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        SqlSelect subSelect = (SqlSelect)call.operand(0);
        subSelect.validateExpr(validator, scope);
        SqlValidatorNamespace ns = Objects.requireNonNull(validator.getNamespace(subSelect), () -> "namespace is missing for " + subSelect);
        RelDataType rowType = Objects.requireNonNull(ns.getRowType(), "rowType");
        SqlCallBinding opBinding = new SqlCallBinding(validator, scope, call);
        return this.typeTransform.transformType(opBinding, rowType);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.keyword(this.getName());
        SqlWriter.Frame frame = writer.startList("(", ")");
        assert (call.operandCount() == 1);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    @Override
    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

