/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCollation;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.type.NonNullableAccessors;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.util.Litmus;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlPrefixOperator
extends SqlOperator {
    public SqlPrefixOperator(String name, SqlKind kind, int prec, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker) {
        super(name, kind, SqlPrefixOperator.leftPrec(prec, true), SqlPrefixOperator.rightPrec(prec, true), returnTypeInference, operandTypeInference, operandTypeChecker);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.PREFIX;
    }

    @Override
    public @Nullable String getSignatureTemplate(int operandsCount) {
        Util.discard(operandsCount);
        return "{0}{1}";
    }

    @Override
    protected RelDataType adjustType(SqlValidator validator, SqlCall call, RelDataType type) {
        if (SqlTypeUtil.inCharFamily(type)) {
            RelDataType operandType = validator.getValidatedNodeType((SqlNode)call.operand(0));
            if (null == operandType) {
                throw new AssertionError((Object)"operand's type should have been derived");
            }
            if (SqlTypeUtil.inCharFamily(operandType)) {
                SqlCollation collation = NonNullableAccessors.getCollation(operandType);
                type = validator.getTypeFactory().createTypeWithCharsetAndCollation(type, NonNullableAccessors.getCharset(type), collation);
            }
        }
        return type;
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        if (this.getName().equals("-")) {
            return call.getOperandMonotonicity(0).reverse();
        }
        return super.getMonotonicity(call);
    }

    @Override
    public boolean validRexOperands(int count, Litmus litmus) {
        if (count != 1) {
            return litmus.fail("wrong operand count {} for {}", count, this);
        }
        return litmus.succeed();
    }
}

