/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.SqlWriterConfig;
import com.hazelcast.org.apache.calcite.sql.dialect.AnsiSqlDialect;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import com.hazelcast.org.apache.calcite.sql.util.SqlString;
import com.hazelcast.org.apache.calcite.sql.util.SqlVisitor;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMoniker;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonotonicity;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Litmus;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;

public abstract class SqlNode
implements Cloneable {
    public static final @Nullable SqlNode[] EMPTY_ARRAY = new SqlNode[0];
    protected final SqlParserPos pos;

    SqlNode(SqlParserPos pos) {
        this.pos = Objects.requireNonNull(pos, "pos");
    }

    @Deprecated
    public Object clone() {
        return this.clone(this.getParserPosition());
    }

    public static <E extends SqlNode> E clone(E e) {
        return (E)e.clone(e.pos);
    }

    public abstract SqlNode clone(SqlParserPos var1);

    public SqlKind getKind() {
        return SqlKind.OTHER;
    }

    public final boolean isA(Set<SqlKind> category) {
        return this.getKind().belongsTo(category);
    }

    @Deprecated
    public static SqlNode[] cloneArray(SqlNode[] nodes) {
        SqlNode[] clones = (SqlNode[])nodes.clone();
        for (int i = 0; i < clones.length; ++i) {
            SqlNode node = clones[i];
            if (node == null) continue;
            clones[i] = SqlNode.clone(node);
        }
        return clones;
    }

    public String toString() {
        return this.toSqlString(c -> c.withDialect(AnsiSqlDialect.DEFAULT).withAlwaysUseParentheses(false).withSelectListItemsOnSeparateLines(false).withUpdateSetListNewline(false).withIndentation(0)).getSql();
    }

    public SqlString toSqlString(UnaryOperator<SqlWriterConfig> transform) {
        SqlWriterConfig config = (SqlWriterConfig)transform.apply(SqlPrettyWriter.config());
        SqlPrettyWriter writer = new SqlPrettyWriter(config);
        this.unparse(writer, 0, 0);
        return writer.toSqlString();
    }

    public SqlString toSqlString(@Nullable SqlDialect dialect, boolean forceParens) {
        return this.toSqlString(c -> c.withDialect(Util.first(dialect, AnsiSqlDialect.DEFAULT)).withAlwaysUseParentheses(forceParens).withSelectListItemsOnSeparateLines(false).withUpdateSetListNewline(false).withIndentation(0));
    }

    public SqlString toSqlString(@Nullable SqlDialect dialect) {
        return this.toSqlString(dialect, false);
    }

    public abstract void unparse(SqlWriter var1, int var2, int var3);

    public void unparseWithParentheses(SqlWriter writer, int leftPrec, int rightPrec, boolean parentheses) {
        if (parentheses) {
            SqlWriter.Frame frame = writer.startList("(", ")");
            this.unparse(writer, 0, 0);
            writer.endList(frame);
        } else {
            this.unparse(writer, leftPrec, rightPrec);
        }
    }

    public SqlParserPos getParserPosition() {
        return this.pos;
    }

    public abstract void validate(SqlValidator var1, SqlValidatorScope var2);

    public void findValidOptions(SqlValidator validator, SqlValidatorScope scope, SqlParserPos pos, Collection<SqlMoniker> hintList) {
    }

    public void validateExpr(SqlValidator validator, SqlValidatorScope scope) {
        this.validate(validator, scope);
        Util.discard(validator.deriveType(scope, this));
    }

    public abstract <R> R accept(SqlVisitor<R> var1);

    public abstract boolean equalsDeep(@Nullable SqlNode var1, Litmus var2);

    @Deprecated
    public final boolean equalsDeep(@Nullable SqlNode node, boolean fail) {
        return this.equalsDeep(node, fail ? Litmus.THROW : Litmus.IGNORE);
    }

    public static boolean equalDeep(@Nullable SqlNode node1, @Nullable SqlNode node2, Litmus litmus) {
        if (node1 == null) {
            return node2 == null;
        }
        if (node2 == null) {
            return false;
        }
        return node1.equalsDeep(node2, litmus);
    }

    public SqlMonotonicity getMonotonicity(@Nullable SqlValidatorScope scope) {
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    public static boolean equalDeep(List<SqlNode> operands0, List<SqlNode> operands1, Litmus litmus) {
        if (operands0.size() != operands1.size()) {
            return litmus.fail(null, new Object[0]);
        }
        for (int i = 0; i < operands0.size(); ++i) {
            if (SqlNode.equalDeep(operands0.get(i), operands1.get(i), litmus)) continue;
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public static <T extends SqlNode> Collector<T, ArrayList<@Nullable SqlNode>, SqlNodeList> toList() {
        return SqlNode.toList(SqlParserPos.ZERO);
    }

    public static <T extends SqlNode> Collector<T, ArrayList<@Nullable SqlNode>, SqlNodeList> toList(SqlParserPos pos) {
        return Collector.of(ArrayList::new, ArrayList::add, Util::combine, list -> SqlNodeList.of(pos, list), new Collector.Characteristics[0]);
    }
}

