/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.schema.impl;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.adapter.java.AbstractQueryableTable;
import com.hazelcast.org.apache.calcite.jdbc.CalciteSchema;
import com.hazelcast.org.apache.calcite.linq4j.QueryProvider;
import com.hazelcast.org.apache.calcite.linq4j.Queryable;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelRoot;
import com.hazelcast.org.apache.calcite.rel.RelShuttleImpl;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelProtoDataType;
import com.hazelcast.org.apache.calcite.schema.Schema;
import com.hazelcast.org.apache.calcite.schema.SchemaPlus;
import com.hazelcast.org.apache.calcite.schema.TranslatableTable;
import com.hazelcast.org.apache.calcite.schema.impl.ViewTableMacro;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Type;
import java.util.List;

public class ViewTable
extends AbstractQueryableTable
implements TranslatableTable {
    private final String viewSql;
    private final List<String> schemaPath;
    private final RelProtoDataType protoRowType;
    private final @Nullable List<String> viewPath;

    public ViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath, @Nullable List<String> viewPath) {
        super(elementType);
        this.viewSql = viewSql;
        this.schemaPath = ImmutableList.copyOf(schemaPath);
        this.protoRowType = rowType;
        this.viewPath = viewPath == null ? null : ImmutableList.copyOf(viewPath);
    }

    @Deprecated
    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath) {
        return ViewTable.viewMacro(schema, viewSql, schemaPath, null, Boolean.TRUE);
    }

    @Deprecated
    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath, @Nullable Boolean modifiable) {
        return ViewTable.viewMacro(schema, viewSql, schemaPath, null, modifiable);
    }

    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath, @Nullable List<String> viewPath, @Nullable Boolean modifiable) {
        return new ViewTableMacro(CalciteSchema.from(schema), viewSql, schemaPath, viewPath, modifiable);
    }

    public String getViewSql() {
        return this.viewSql;
    }

    public List<String> getSchemaPath() {
        return this.schemaPath;
    }

    public @Nullable List<String> getViewPath() {
        return this.viewPath;
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.VIEW;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return queryProvider.createQuery(this.getExpression(schema, tableName, Queryable.class), this.elementType);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return this.expandView((RelOptTable.ToRelContext)context, (RelDataType)relOptTable.getRowType(), (String)this.viewSql).rel;
    }

    private RelRoot expandView(final RelOptTable.ToRelContext context, RelDataType rowType, String queryString) {
        try {
            RelRoot root = context.expandView(rowType, queryString, this.schemaPath, this.viewPath);
            RelNode rel = RelOptUtil.createCastRel(root.rel, rowType, true);
            RelNode rel2 = rel.accept(new RelShuttleImpl(){

                @Override
                public RelNode visit(TableScan scan) {
                    RelOptTable table = scan.getTable();
                    TranslatableTable translatableTable = table.unwrap(TranslatableTable.class);
                    if (translatableTable != null) {
                        return translatableTable.toRel(context, table);
                    }
                    return super.visit(scan);
                }
            });
            return root.withRel(rel2);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while parsing view definition: " + queryString, e);
        }
    }
}

