/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rex;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.org.apache.calcite.rex.RexWindowBound;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlWindow;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Objects;

public final class RexWindowBounds {
    public static final RexWindowBound UNBOUNDED_PRECEDING = new RexUnboundedWindowBound(true);
    public static final RexWindowBound UNBOUNDED_FOLLOWING = new RexUnboundedWindowBound(false);
    public static final RexWindowBound CURRENT_ROW = new RexCurrentRowWindowBound();

    private RexWindowBounds() {
    }

    public static RexWindowBound create(SqlNode node, @Nullable RexNode rexNode) {
        if (SqlWindow.isUnboundedPreceding(node)) {
            return UNBOUNDED_PRECEDING;
        }
        if (SqlWindow.isUnboundedFollowing(node)) {
            return UNBOUNDED_FOLLOWING;
        }
        if (SqlWindow.isCurrentRow(node)) {
            return CURRENT_ROW;
        }
        assert (rexNode != null) : "offset value cannot be null for bounded window";
        return new RexBoundedWindowBound((RexCall)rexNode);
    }

    public static RexWindowBound following(RexNode offset) {
        return new RexBoundedWindowBound(new RexCall(offset.getType(), SqlWindow.FOLLOWING_OPERATOR, ImmutableList.of(offset)));
    }

    public static RexWindowBound preceding(RexNode offset) {
        return new RexBoundedWindowBound(new RexCall(offset.getType(), SqlWindow.PRECEDING_OPERATOR, ImmutableList.of(offset)));
    }

    private static class RexBoundedWindowBound
    extends RexWindowBound {
        private final SqlKind sqlKind;
        private final RexNode offset;

        RexBoundedWindowBound(RexCall node) {
            this.offset = (RexNode)Objects.requireNonNull(node.operands.get(0));
            this.sqlKind = Objects.requireNonNull(node.getKind());
        }

        private RexBoundedWindowBound(SqlKind sqlKind, RexNode offset) {
            this.sqlKind = sqlKind;
            this.offset = offset;
        }

        @Override
        public boolean isPreceding() {
            return this.sqlKind == SqlKind.PRECEDING;
        }

        @Override
        public boolean isFollowing() {
            return this.sqlKind == SqlKind.FOLLOWING;
        }

        @Override
        public RexNode getOffset() {
            return this.offset;
        }

        @Override
        public int nodeCount() {
            return super.nodeCount() + this.offset.nodeCount();
        }

        @Override
        public <R> RexWindowBound accept(RexVisitor<R> visitor) {
            R r = this.offset.accept(visitor);
            if (r instanceof RexNode && r != this.offset) {
                return new RexBoundedWindowBound(this.sqlKind, (RexNode)r);
            }
            return this;
        }

        public String toString() {
            return this.offset + " " + (Object)((Object)this.sqlKind);
        }

        public boolean equals(@Nullable Object o) {
            return this == o || o instanceof RexBoundedWindowBound && this.offset.equals(((RexBoundedWindowBound)o).offset) && this.sqlKind == ((RexBoundedWindowBound)o).sqlKind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sqlKind, this.offset});
        }
    }

    private static class RexCurrentRowWindowBound
    extends RexWindowBound {
        private RexCurrentRowWindowBound() {
        }

        @Override
        public boolean isCurrentRow() {
            return true;
        }

        public String toString() {
            return "CURRENT ROW";
        }

        @Override
        public int getOrderKey() {
            return 1;
        }

        public boolean equals(@Nullable Object o) {
            return this == o || o instanceof RexCurrentRowWindowBound;
        }

        public int hashCode() {
            return 123;
        }
    }

    private static class RexUnboundedWindowBound
    extends RexWindowBound {
        private final boolean preceding;

        RexUnboundedWindowBound(boolean preceding) {
            this.preceding = preceding;
        }

        @Override
        public boolean isUnbounded() {
            return true;
        }

        @Override
        public boolean isPreceding() {
            return this.preceding;
        }

        @Override
        public boolean isFollowing() {
            return !this.preceding;
        }

        public String toString() {
            return this.preceding ? "UNBOUNDED PRECEDING" : "UNBOUNDED FOLLOWING";
        }

        @Override
        public int getOrderKey() {
            return this.preceding ? 0 : 2;
        }

        public boolean equals(@Nullable Object o) {
            return this == o || o instanceof RexUnboundedWindowBound && this.preceding == ((RexUnboundedWindowBound)o).preceding;
        }

        public int hashCode() {
            return this.preceding ? 1357 : 1358;
        }
    }
}

