/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelCollations;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinInfo;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rel.core.Sort;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalSort;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdUtil;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.rules.ImmutableSortJoinTransposeRule;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class SortJoinTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected SortJoinTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public SortJoinTransposeRule(Class<? extends Sort> sortClass, Class<? extends Join> joinClass) {
        this(Config.DEFAULT.withOperandFor(sortClass, joinClass).as(Config.class));
    }

    @Deprecated
    public SortJoinTransposeRule(Class<? extends Sort> sortClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withOperandFor(sortClass, joinClass).withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        Join join = (Join)call.rel(1);
        RelMetadataQuery mq = call.getMetadataQuery();
        JoinInfo joinInfo = JoinInfo.of(join.getLeft(), join.getRight(), join.getCondition());
        if (join.getJoinType() == JoinRelType.LEFT) {
            if (sort.getCollation() != RelCollations.EMPTY) {
                for (RelFieldCollation relFieldCollation : sort.getCollation().getFieldCollations()) {
                    if (relFieldCollation.getFieldIndex() < join.getLeft().getRowType().getFieldCount()) continue;
                    return false;
                }
            }
            if (sort.offset != null && !RelMdUtil.areColumnsDefinitelyUnique(mq, join.getRight(), joinInfo.rightSet())) {
                return false;
            }
        } else if (join.getJoinType() == JoinRelType.RIGHT) {
            if (sort.getCollation() != RelCollations.EMPTY) {
                for (RelFieldCollation relFieldCollation : sort.getCollation().getFieldCollations()) {
                    if (relFieldCollation.getFieldIndex() >= join.getLeft().getRowType().getFieldCount()) continue;
                    return false;
                }
            }
            if (sort.offset != null && !RelMdUtil.areColumnsDefinitelyUnique(mq, join.getLeft(), joinInfo.leftSet())) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode newRightInput;
        RelNode newLeftInput;
        Sort sort = (Sort)call.rel(0);
        Join join = (Join)call.rel(1);
        RelMetadataQuery mq = call.getMetadataQuery();
        if (join.getJoinType() == JoinRelType.LEFT) {
            if (RelMdUtil.checkInputForCollationAndLimit(mq, join.getLeft(), sort.getCollation(), sort.offset, sort.fetch)) {
                return;
            }
            newLeftInput = sort.copy(sort.getTraitSet(), join.getLeft(), sort.getCollation(), sort.offset, sort.fetch);
            newRightInput = join.getRight();
        } else {
            RelCollation rightCollation = RelCollationTraitDef.INSTANCE.canonize(RelCollations.shift(sort.getCollation(), -join.getLeft().getRowType().getFieldCount()));
            if (RelMdUtil.checkInputForCollationAndLimit(mq, join.getRight(), rightCollation, sort.offset, sort.fetch)) {
                return;
            }
            newLeftInput = join.getLeft();
            newRightInput = sort.copy(sort.getTraitSet().replace(rightCollation), join.getRight(), rightCollation, sort.offset, sort.fetch);
        }
        Join joinCopy = join.copy(join.getTraitSet(), join.getCondition(), newLeftInput, newRightInput, join.getJoinType(), join.isSemiJoinDone());
        Sort sortCopy = sort.copy(sort.getTraitSet(), joinCopy, sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(sortCopy);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortJoinTransposeRule.Config.of().withOperandFor(LogicalSort.class, LogicalJoin.class);

        @Override
        default public SortJoinTransposeRule toRule() {
            return new SortJoinTransposeRule(this);
        }

        default public Config withOperandFor(Class<? extends Sort> sortClass, Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(sortClass).oneInput(b1 -> b1.operand(joinClass).anyInputs())).as(Config.class);
        }
    }
}

