/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.Contexts;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.plan.Strong;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalProject;
import com.hazelcast.org.apache.calcite.rel.rules.ImmutableJoinProjectTransposeRule;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexLocalRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinProjectTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected JoinProjectTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public JoinProjectTransposeRule(RelOptRuleOperand operand, String description, boolean includeOuter, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withDescription(description).withRelBuilderFactory(relBuilderFactory).withOperandSupplier(b -> b.exactly(operand)).as(Config.class).withIncludeOuter(includeOuter));
    }

    @Deprecated
    public JoinProjectTransposeRule(RelOptRuleOperand operand, String description) {
        this(Config.DEFAULT.withDescription(description).withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
    }

    @Deprecated
    public JoinProjectTransposeRule(RelOptRuleOperand operand, String description, RelFactories.ProjectFactory projectFactory) {
        this(Config.DEFAULT.withDescription(description).withRelBuilderFactory(RelBuilder.proto(Contexts.of((Object)projectFactory))).withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
    }

    @Deprecated
    public JoinProjectTransposeRule(RelOptRuleOperand operand, String description, boolean includeOuter, RelFactories.ProjectFactory projectFactory) {
        this(Config.DEFAULT.withDescription(description).withRelBuilderFactory(RelBuilder.proto(Contexts.of((Object)projectFactory))).withOperandSupplier(b -> b.exactly(operand)).as(Config.class).withIncludeOuter(includeOuter));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode rightJoinChild;
        Project rightProject;
        Object leftJoinChild;
        Project leftProject;
        Join join = (Join)call.rel(0);
        JoinRelType joinType = join.getJoinType();
        boolean includeOuter = ((Config)this.config).isIncludeOuter();
        if (this.hasLeftChild(call) && (includeOuter || !joinType.generatesNullsOnLeft())) {
            leftProject = (Project)call.rel(1);
            leftJoinChild = this.getProjectChild(call, leftProject, true);
        } else {
            leftProject = null;
            leftJoinChild = call.rel(1);
        }
        if (this.hasRightChild(call) && (includeOuter || !joinType.generatesNullsOnRight())) {
            rightProject = this.getRightChild(call);
            rightJoinChild = this.getProjectChild(call, rightProject, false);
        } else {
            rightProject = null;
            rightJoinChild = join.getRight();
        }
        if (leftProject != null && leftProject.containsOver()) {
            leftProject = null;
            leftJoinChild = join.getLeft();
        }
        if (rightProject != null && rightProject.containsOver()) {
            rightProject = null;
            rightJoinChild = join.getRight();
        }
        if (leftProject == null && rightProject == null) {
            return;
        }
        if (includeOuter) {
            if (leftProject != null && joinType.generatesNullsOnLeft() && !Strong.allStrong(leftProject.getProjects())) {
                return;
            }
            if (rightProject != null && joinType.generatesNullsOnRight() && !Strong.allStrong(rightProject.getProjects())) {
                return;
            }
        }
        RelDataType joinChildrenRowType = SqlValidatorUtil.deriveJoinRowType(leftJoinChild.getRowType(), rightJoinChild.getRowType(), JoinRelType.INNER, join.getCluster().getTypeFactory(), null, Collections.emptyList());
        int nProjExprs = join.getRowType().getFieldCount();
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        this.createProjectExprs(leftProject, (RelNode)leftJoinChild, 0, rexBuilder, joinChildrenRowType.getFieldList(), (List<Pair<RexNode, String>>)projects);
        List<RelDataTypeField> leftFields = leftJoinChild.getRowType().getFieldList();
        int nFieldsLeft = leftFields.size();
        this.createProjectExprs(rightProject, rightJoinChild, nFieldsLeft, rexBuilder, joinChildrenRowType.getFieldList(), projects);
        ArrayList<RelDataType> projTypes = new ArrayList<RelDataType>();
        for (int i = 0; i < nProjExprs; ++i) {
            projTypes.add(((RexNode)((Pair)projects.get((int)i)).left).getType());
        }
        RelDataType projRowType = rexBuilder.getTypeFactory().createStructType(projTypes, Pair.right(projects));
        RexProgram bottomProgram = RexProgram.create(joinChildrenRowType, Pair.left(projects), null, projRowType, rexBuilder);
        RexProgramBuilder topProgramBuilder = new RexProgramBuilder(projRowType, rexBuilder);
        topProgramBuilder.addIdentity();
        topProgramBuilder.addCondition(join.getCondition());
        RexProgram topProgram = topProgramBuilder.getProgram();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        RexNode newCondition = mergedProgram.expandLocalRef(Objects.requireNonNull(mergedProgram.getCondition(), () -> "mergedProgram.getCondition() for " + mergedProgram));
        Join newJoin = join.copy(join.getTraitSet(), newCondition, (RelNode)leftJoinChild, rightJoinChild, join.getJoinType(), join.isSemiJoinDone());
        ArrayList<RexNode> newProjExprs = new ArrayList<RexNode>();
        List<RexLocalRef> projList = mergedProgram.getProjectList();
        List<RelDataTypeField> newJoinFields = newJoin.getRowType().getFieldList();
        int nJoinFields = newJoinFields.size();
        int[] adjustments = new int[nJoinFields];
        for (int i = 0; i < nProjExprs; ++i) {
            RexNode newExpr = mergedProgram.expandLocalRef(projList.get(i));
            if (joinType.isOuterJoin()) {
                newExpr = newExpr.accept(new RelOptUtil.RexInputConverter(rexBuilder, joinChildrenRowType.getFieldList(), newJoinFields, adjustments));
            }
            newProjExprs.add(newExpr);
        }
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newJoin);
        relBuilder.project(newProjExprs, join.getRowType().getFieldNames());
        if (joinType.isOuterJoin()) {
            relBuilder.convert(join.getRowType(), false);
        }
        call.transformTo(relBuilder.build());
    }

    protected boolean hasLeftChild(RelOptRuleCall call) {
        return call.rel(1) instanceof Project;
    }

    protected boolean hasRightChild(RelOptRuleCall call) {
        return call.rels.length == 3;
    }

    protected Project getRightChild(RelOptRuleCall call) {
        return (Project)call.rel(2);
    }

    protected RelNode getProjectChild(RelOptRuleCall call, Project project, boolean leftChild) {
        return project.getInput();
    }

    protected void createProjectExprs(@Nullable Project project, RelNode joinChild, int adjustmentAmount, RexBuilder rexBuilder, List<RelDataTypeField> joinChildrenFields, List<Pair<RexNode, String>> projects) {
        List<RelDataTypeField> childFields = joinChild.getRowType().getFieldList();
        if (project != null) {
            List<Pair<RexNode, String>> namedProjects = project.getNamedProjects();
            int nChildFields = childFields.size();
            int[] adjustments = new int[nChildFields];
            for (int i = 0; i < nChildFields; ++i) {
                adjustments[i] = adjustmentAmount;
            }
            for (Pair<RexNode, String> pair : namedProjects) {
                RexNode e = (RexNode)pair.left;
                if (adjustmentAmount != 0) {
                    e = e.accept(new RelOptUtil.RexInputConverter(rexBuilder, childFields, joinChildrenFields, adjustments));
                }
                projects.add(Pair.of(e, pair.right));
            }
        } else {
            for (int i = 0; i < childFields.size(); ++i) {
                RelDataTypeField field = childFields.get(i);
                projects.add(Pair.of(rexBuilder.makeInputRef(field.getType(), i + adjustmentAmount), field.getName()));
            }
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinProjectTransposeRule.Config.of().withOperandSupplier(b0 -> b0.operand(LogicalJoin.class).inputs(b1 -> b1.operand(LogicalProject.class).anyInputs(), b2 -> b2.operand(LogicalProject.class).anyInputs())).withDescription("JoinProjectTransposeRule(Project-Project)");
        public static final Config LEFT = DEFAULT.withOperandSupplier(b0 -> b0.operand(LogicalJoin.class).inputs(b1 -> b1.operand(LogicalProject.class).anyInputs())).withDescription("JoinProjectTransposeRule(Project-Other)").as(Config.class);
        public static final Config RIGHT = DEFAULT.withOperandSupplier(b0 -> b0.operand(LogicalJoin.class).inputs(b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(LogicalProject.class).anyInputs())).withDescription("JoinProjectTransposeRule(Other-Project)").as(Config.class);
        public static final Config OUTER = DEFAULT.withDescription("Join(IncludingOuter)ProjectTransposeRule(Project-Project)").as(Config.class).withIncludeOuter(true);
        public static final Config LEFT_OUTER = LEFT.withDescription("Join(IncludingOuter)ProjectTransposeRule(Project-Other)").as(Config.class).withIncludeOuter(true);
        public static final Config RIGHT_OUTER = RIGHT.withDescription("Join(IncludingOuter)ProjectTransposeRule(Other-Project)").as(Config.class).withIncludeOuter(true);

        @Override
        default public JoinProjectTransposeRule toRule() {
            return new JoinProjectTransposeRule(this);
        }

        @Value.Default
        default public boolean isIncludeOuter() {
            return false;
        }

        public Config withIncludeOuter(boolean var1);
    }
}

