/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.com.google.common.base.MoreObjects;
import com.hazelcast.com.google.common.primitives.Booleans;
import com.hazelcast.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.rules.JoinAssociateRule;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="JoinAssociateRule", generator="Immutables")
final class ImmutableJoinAssociateRule {
    private ImmutableJoinAssociateRule() {
    }

    @CheckReturnValue
    @Generated(from="JoinAssociateRule.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements JoinAssociateRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @Nullable
        private final @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description;
        private final RelRule.OperandTransform operandSupplier;
        private final boolean allowAlwaysTrueCondition;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private static final Config INSTANCE = Config.validate(new Config());

        private Config() {
            this.description = null;
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.allowAlwaysTrueCondition = this.initShim.isAllowAlwaysTrueCondition();
            this.initShim = null;
        }

        private Config(Builder builder) {
            this.description = builder.description;
            if (builder.relBuilderFactory != null) {
                this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.operandSupplier != null) {
                this.initShim.withOperandSupplier(builder.operandSupplier);
            }
            if (builder.allowAlwaysTrueConditionIsSet()) {
                this.initShim.withAllowAlwaysTrueCondition(builder.allowAlwaysTrueCondition);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.allowAlwaysTrueCondition = this.initShim.isAllowAlwaysTrueCondition();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @Nullable @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description, RelRule.OperandTransform operandSupplier, boolean allowAlwaysTrueCondition) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description;
            this.operandSupplier = operandSupplier;
            this.allowAlwaysTrueCondition = allowAlwaysTrueCondition;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return JoinAssociateRule.Config.super.relBuilderFactory();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return JoinAssociateRule.Config.super.operandSupplier();
        }

        private boolean isAllowAlwaysTrueConditionInitialize() {
            return JoinAssociateRule.Config.super.isAllowAlwaysTrueCondition();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @Nullable
        public @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description() {
            return this.description;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        @Override
        public boolean isAllowAlwaysTrueCondition() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isAllowAlwaysTrueCondition() : this.allowAlwaysTrueCondition;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return Config.validate(new Config(newValue, this.description, this.operandSupplier, this.allowAlwaysTrueCondition));
        }

        @Override
        public final Config withDescription(@Nullable @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, value, this.operandSupplier, this.allowAlwaysTrueCondition));
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return Config.validate(new Config(this.relBuilderFactory, this.description, newValue, this.allowAlwaysTrueCondition));
        }

        @Override
        public final Config withAllowAlwaysTrueCondition(boolean value) {
            if (this.allowAlwaysTrueCondition == value) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.operandSupplier, value));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier) && this.allowAlwaysTrueCondition == another.allowAlwaysTrueCondition;
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.relBuilderFactory.hashCode();
            h2 += (h2 << 5) + Objects.hashCode(this.description);
            h2 += (h2 << 5) + this.operandSupplier.hashCode();
            h2 += (h2 << 5) + Booleans.hashCode(this.allowAlwaysTrueCondition);
            return h2;
        }

        public String toString() {
            return MoreObjects.toStringHelper("Config").omitNullValues().add("relBuilderFactory", this.relBuilderFactory).add("description", this.description).add("operandSupplier", this.operandSupplier).add("allowAlwaysTrueCondition", this.allowAlwaysTrueCondition).toString();
        }

        public static Config of() {
            return INSTANCE;
        }

        private static Config validate(Config instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        public static Config copyOf(JoinAssociateRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="JoinAssociateRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_ALLOW_ALWAYS_TRUE_CONDITION = 1L;
            private long optBits;
            @Nullable
            private RelBuilderFactory relBuilderFactory;
            @Nullable
            private @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description;
            @Nullable
            private RelRule.OperandTransform operandSupplier;
            private boolean allowAlwaysTrueCondition;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(JoinAssociateRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                if (object instanceof RelRule.Config) {
                    instance = (RelRule.Config)object;
                    this.withRelBuilderFactory(instance.relBuilderFactory());
                    this.withOperandSupplier(instance.operandSupplier());
                    @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.withDescription(descriptionValue);
                    }
                }
                if (object instanceof JoinAssociateRule.Config) {
                    instance = (JoinAssociateRule.Config)object;
                    this.withAllowAlwaysTrueCondition(instance.isAllowAlwaysTrueCondition());
                }
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDescription(@Nullable @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withAllowAlwaysTrueCondition(boolean allowAlwaysTrueCondition) {
                this.allowAlwaysTrueCondition = allowAlwaysTrueCondition;
                this.optBits |= 1L;
                return this;
            }

            public Config build() {
                return Config.validate(new Config(this));
            }

            private boolean allowAlwaysTrueConditionIsSet() {
                return (this.optBits & 1L) != 0L;
            }
        }

        @Generated(from="JoinAssociateRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;
            private byte allowAlwaysTrueConditionBuildStage = 0;
            private boolean allowAlwaysTrueCondition;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            boolean isAllowAlwaysTrueCondition() {
                if (this.allowAlwaysTrueConditionBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.allowAlwaysTrueConditionBuildStage == 0) {
                    this.allowAlwaysTrueConditionBuildStage = (byte)-1;
                    this.allowAlwaysTrueCondition = Config.this.isAllowAlwaysTrueConditionInitialize();
                    this.allowAlwaysTrueConditionBuildStage = 1;
                }
                return this.allowAlwaysTrueCondition;
            }

            void withAllowAlwaysTrueCondition(boolean allowAlwaysTrueCondition) {
                this.allowAlwaysTrueCondition = allowAlwaysTrueCondition;
                this.allowAlwaysTrueConditionBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                if (this.allowAlwaysTrueConditionBuildStage == -1) {
                    attributes.add("allowAlwaysTrueCondition");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

