/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.com.google.common.base.MoreObjects;
import com.hazelcast.com.google.common.primitives.Booleans;
import com.hazelcast.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.rules.AggregateJoinTransposeRule;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AggregateJoinTransposeRule", generator="Immutables")
final class ImmutableAggregateJoinTransposeRule {
    private ImmutableAggregateJoinTransposeRule() {
    }

    @CheckReturnValue
    @Generated(from="AggregateJoinTransposeRule.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements AggregateJoinTransposeRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @Nullable
        private final @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description;
        private final RelRule.OperandTransform operandSupplier;
        private final boolean allowFunctions;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private static final Config INSTANCE = Config.validate(new Config());

        private Config() {
            this.description = null;
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.allowFunctions = this.initShim.isAllowFunctions();
            this.initShim = null;
        }

        private Config(Builder builder) {
            this.description = builder.description;
            if (builder.relBuilderFactory != null) {
                this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.operandSupplier != null) {
                this.initShim.withOperandSupplier(builder.operandSupplier);
            }
            if (builder.allowFunctionsIsSet()) {
                this.initShim.withAllowFunctions(builder.allowFunctions);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.allowFunctions = this.initShim.isAllowFunctions();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @Nullable @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description, RelRule.OperandTransform operandSupplier, boolean allowFunctions) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description;
            this.operandSupplier = operandSupplier;
            this.allowFunctions = allowFunctions;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return AggregateJoinTransposeRule.Config.super.relBuilderFactory();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return AggregateJoinTransposeRule.Config.super.operandSupplier();
        }

        private boolean isAllowFunctionsInitialize() {
            return AggregateJoinTransposeRule.Config.super.isAllowFunctions();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @Nullable
        public @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description() {
            return this.description;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        @Override
        public boolean isAllowFunctions() {
            InitShim shim = this.initShim;
            return shim != null ? shim.isAllowFunctions() : this.allowFunctions;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return Config.validate(new Config(newValue, this.description, this.operandSupplier, this.allowFunctions));
        }

        @Override
        public final Config withDescription(@Nullable @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, value, this.operandSupplier, this.allowFunctions));
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return Config.validate(new Config(this.relBuilderFactory, this.description, newValue, this.allowFunctions));
        }

        @Override
        public final Config withAllowFunctions(boolean value) {
            if (this.allowFunctions == value) {
                return this;
            }
            return Config.validate(new Config(this.relBuilderFactory, this.description, this.operandSupplier, value));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier) && this.allowFunctions == another.allowFunctions;
        }

        public int hashCode() {
            int h2 = 5381;
            h2 += (h2 << 5) + this.relBuilderFactory.hashCode();
            h2 += (h2 << 5) + Objects.hashCode(this.description);
            h2 += (h2 << 5) + this.operandSupplier.hashCode();
            h2 += (h2 << 5) + Booleans.hashCode(this.allowFunctions);
            return h2;
        }

        public String toString() {
            return MoreObjects.toStringHelper("Config").omitNullValues().add("relBuilderFactory", this.relBuilderFactory).add("description", this.description).add("operandSupplier", this.operandSupplier).add("allowFunctions", this.allowFunctions).toString();
        }

        public static Config of() {
            return INSTANCE;
        }

        private static Config validate(Config instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        public static Config copyOf(AggregateJoinTransposeRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="AggregateJoinTransposeRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_ALLOW_FUNCTIONS = 1L;
            private long optBits;
            @Nullable
            private RelBuilderFactory relBuilderFactory;
            @Nullable
            private @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description;
            @Nullable
            private RelRule.OperandTransform operandSupplier;
            private boolean allowFunctions;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(AggregateJoinTransposeRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                if (object instanceof RelRule.Config) {
                    instance = (RelRule.Config)object;
                    this.withRelBuilderFactory(instance.relBuilderFactory());
                    this.withOperandSupplier(instance.operandSupplier());
                    @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.withDescription(descriptionValue);
                    }
                }
                if (object instanceof AggregateJoinTransposeRule.Config) {
                    instance = (AggregateJoinTransposeRule.Config)object;
                    this.withAllowFunctions(instance.isAllowFunctions());
                }
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDescription(@Nullable @com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withAllowFunctions(boolean allowFunctions) {
                this.allowFunctions = allowFunctions;
                this.optBits |= 1L;
                return this;
            }

            public Config build() {
                return Config.validate(new Config(this));
            }

            private boolean allowFunctionsIsSet() {
                return (this.optBits & 1L) != 0L;
            }
        }

        @Generated(from="AggregateJoinTransposeRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;
            private byte allowFunctionsBuildStage = 0;
            private boolean allowFunctions;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            boolean isAllowFunctions() {
                if (this.allowFunctionsBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.allowFunctionsBuildStage == 0) {
                    this.allowFunctionsBuildStage = (byte)-1;
                    this.allowFunctions = Config.this.isAllowFunctionsInitialize();
                    this.allowFunctionsBuildStage = 1;
                }
                return this.allowFunctions;
            }

            void withAllowFunctions(boolean allowFunctions) {
                this.allowFunctions = allowFunctions;
                this.allowFunctionsBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                if (this.allowFunctionsBuildStage == -1) {
                    attributes.add("allowFunctions");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

