/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.rules.ImmutableFilterFlattenCorrelatedConditionRule;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;
import org.apiguardian.api.API;
import org.immutables.value.Value;

@API(since="1.27", status=API.Status.EXPERIMENTAL)
@Value.Enclosing
public final class FilterFlattenCorrelatedConditionRule
extends RelRule<Config> {
    public FilterFlattenCorrelatedConditionRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        return RexUtil.containsCorrelation(filter.getCondition());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        final RelBuilder b = call.builder();
        b.push(filter.getInput());
        final int proj = b.fields().size();
        final ArrayList<RexNode> projOperands = new ArrayList<RexNode>();
        RexNode newCondition = filter.getCondition().accept(new RexShuttle(){

            @Override
            public RexNode visitCall(RexCall call) {
                switch (call.getKind()) {
                    case EQUALS: 
                    case NOT_EQUALS: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case IS_DISTINCT_FROM: 
                    case IS_NOT_DISTINCT_FROM: {
                        RexNode op0 = (RexNode)call.operands.get(0);
                        RexNode op1 = (RexNode)call.operands.get(1);
                        int replaceIndex = RexUtil.containsCorrelation(op1) && FilterFlattenCorrelatedConditionRule.isUncorrelatedCall(op0) ? 0 : (RexUtil.containsCorrelation(op0) && FilterFlattenCorrelatedConditionRule.isUncorrelatedCall(op1) ? 1 : -1);
                        if (replaceIndex != -1) {
                            ArrayList<RexNode> copyOperands = new ArrayList<RexNode>(call.operands);
                            RexNode oldOp = (RexNode)call.operands.get(replaceIndex);
                            RexInputRef newOp = b.getRexBuilder().makeInputRef(oldOp.getType(), proj + projOperands.size());
                            projOperands.add(oldOp);
                            copyOperands.set(replaceIndex, newOp);
                            return call.clone(call.type, copyOperands);
                        }
                        return call;
                    }
                    case AND: 
                    case OR: {
                        return super.visitCall(call);
                    }
                }
                return call;
            }
        });
        if (newCondition.equals(filter.getCondition())) {
            return;
        }
        b.projectPlus(projOperands);
        b.filter(newCondition);
        b.project(b.fields(ImmutableBitSet.range(proj).asList()));
        call.transformTo(b.build());
    }

    private static boolean isUncorrelatedCall(RexNode node) {
        return node instanceof RexCall && !RexUtil.containsCorrelation(node);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterFlattenCorrelatedConditionRule.Config.of().withOperandSupplier(op -> op.operand(Filter.class).anyInputs());

        @Override
        default public FilterFlattenCorrelatedConditionRule toRule() {
            return new FilterFlattenCorrelatedConditionRule(this);
        }
    }
}

