/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.logical;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelCollations;
import com.hazelcast.org.apache.calcite.rel.RelInput;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelShuttle;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.hint.RelHint;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdCollation;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public final class LogicalProject
extends Project {
    public LogicalProject(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, hints, input, projects, rowType);
        assert (traitSet.containsIfApplicable(Convention.NONE));
    }

    @Deprecated
    public LogicalProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        this(cluster, traitSet, ImmutableList.of(), input, projects, rowType);
    }

    @Deprecated
    public LogicalProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType, int flags) {
        this(cluster, traitSet, ImmutableList.of(), input, projects, rowType);
        Util.discard(flags);
    }

    @Deprecated
    public LogicalProject(RelOptCluster cluster, RelNode input, List<RexNode> projects, @Nullable List<? extends @Nullable String> fieldNames, int flags) {
        this(cluster, cluster.traitSetOf((RelTrait)RelCollations.EMPTY), ImmutableList.of(), input, projects, RexUtil.createStructType(cluster.getTypeFactory(), projects, fieldNames, null));
        Util.discard(flags);
    }

    public LogicalProject(RelInput input) {
        super(input);
    }

    public static LogicalProject create(RelNode input, List<RelHint> hints, List<? extends RexNode> projects, @Nullable List<? extends @Nullable String> fieldNames) {
        RelOptCluster cluster = input.getCluster();
        RelDataType rowType = RexUtil.createStructType(cluster.getTypeFactory(), projects, fieldNames, SqlValidatorUtil.F_SUGGESTER);
        return LogicalProject.create(input, hints, projects, rowType);
    }

    public static LogicalProject create(RelNode input, List<RelHint> hints, List<? extends RexNode> projects, RelDataType rowType) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSet().replace(Convention.NONE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.project(mq, input, projects));
        return new LogicalProject(cluster, traitSet, hints, input, projects, rowType);
    }

    @Override
    public LogicalProject copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new LogicalProject(this.getCluster(), traitSet, this.hints, input, projects, rowType);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelNode withHints(List<RelHint> hintList) {
        return new LogicalProject(this.getCluster(), this.traitSet, hintList, this.input, this.getProjects(), this.getRowType());
    }

    @Override
    public boolean deepEquals(@Nullable Object obj) {
        return this.deepEquals0(obj);
    }

    @Override
    public int deepHashCode() {
        return this.deepHashCode0();
    }
}

