/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.core;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelInput;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.SetOp;
import com.hazelcast.org.apache.calcite.rel.hint.RelHint;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdUtil;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import java.util.Collections;
import java.util.List;

public abstract class Union
extends SetOp {
    protected Union(RelOptCluster cluster, RelTraitSet traits, List<RelHint> hints, List<RelNode> inputs, boolean all) {
        super(cluster, traits, hints, inputs, SqlKind.UNION, all);
    }

    protected Union(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits, Collections.emptyList(), inputs, SqlKind.UNION, all);
    }

    protected Union(RelInput input) {
        super(input);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        double dRows = RelMdUtil.getUnionAllRowCount(mq, this);
        if (!this.all) {
            dRows *= 0.5;
        }
        return dRows;
    }

    @Deprecated
    public static double estimateRowCount(RelNode rel) {
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        return RelMdUtil.getUnionAllRowCount(mq, (Union)rel);
    }
}

