/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.core;

import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelDistribution;
import com.hazelcast.org.apache.calcite.rel.RelDistributionTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelDistributions;
import com.hazelcast.org.apache.calcite.rel.RelInput;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelWriter;
import com.hazelcast.org.apache.calcite.rel.SingleRel;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

public abstract class Exchange
extends SingleRel {
    public final RelDistribution distribution;

    protected Exchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDistribution distribution) {
        super(cluster, traitSet, input);
        this.distribution = Objects.requireNonNull(distribution, "distribution");
        assert (traitSet.containsIfApplicable(distribution)) : "traits=" + traitSet + ", distribution=" + distribution;
        assert (distribution != RelDistributions.ANY);
    }

    protected Exchange(RelInput input) {
        this(input.getCluster(), input.getTraitSet().plus(input.getDistribution()), input.getInput(), RelDistributionTraitDef.INSTANCE.canonize(input.getDistribution()));
    }

    @Override
    public final Exchange copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Exchange.sole(inputs), this.distribution);
    }

    public abstract Exchange copy(RelTraitSet var1, RelNode var2, RelDistribution var3);

    public RelDistribution getDistribution() {
        return this.distribution;
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        double bytesPerRow = this.getRowType().getFieldCount() * 4;
        return planner.getCostFactory().makeCost(Util.nLogN(rowCount) * bytesPerRow, rowCount, 0.0);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("distribution", this.distribution);
    }
}

