/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.materialize;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.Ordering;
import com.hazelcast.org.apache.calcite.materialize.LatticeSpace;
import com.hazelcast.org.apache.calcite.materialize.LatticeTable;
import com.hazelcast.org.apache.calcite.materialize.SqlStatisticProvider;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.util.graph.AttributedDirectedGraph;
import com.hazelcast.org.apache.calcite.util.graph.DefaultEdge;
import com.hazelcast.org.apache.calcite.util.mapping.IntPair;
import com.hazelcast.org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import com.hazelcast.org.checkerframework.checker.initialization.qual.UnderInitialization;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;
import java.util.Objects;

class Step
extends DefaultEdge {
    final List<IntPair> keys;
    final String keyString;

    private Step(LatticeTable source, LatticeTable target, List<IntPair> keys, String keyString) {
        super(source, target);
        this.keys = ImmutableList.copyOf(keys);
        this.keyString = Objects.requireNonNull(keyString, "keyString");
        assert (IntPair.ORDERING.isStrictlyOrdered(keys));
    }

    static Step create(LatticeTable source, LatticeTable target, List<IntPair> keys, LatticeSpace space) {
        StringBuilder b = new StringBuilder();
        for (IntPair key : keys) {
            b.append(' ').append(space.fieldName(source, key.source)).append(':').append(space.fieldName(target, key.target));
        }
        return new Step(source, target, keys, b.toString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.target, this.keys);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Step && ((Step)obj).source.equals(this.source) && ((Step)obj).target.equals(this.target) && ((Step)obj).keys.equals(this.keys);
    }

    @Override
    public String toString() {
        return "Step(" + this.source + ", " + this.target + "," + this.keyString + ")";
    }

    LatticeTable source() {
        return (LatticeTable)this.source;
    }

    LatticeTable target() {
        return (LatticeTable)this.target;
    }

    boolean isBackwards(SqlStatisticProvider statisticProvider) {
        boolean backwardForeignKey;
        RelOptTable sourceTable = this.source().t;
        List<Integer> sourceColumns = IntPair.left(this.keys);
        RelOptTable targetTable = this.target().t;
        List<Integer> targetColumns = IntPair.right(this.keys);
        boolean noDerivedSourceColumns = sourceColumns.stream().allMatch(i -> i < sourceTable.getRowType().getFieldCount());
        boolean noDerivedTargetColumns = targetColumns.stream().allMatch(i -> i < targetTable.getRowType().getFieldCount());
        boolean forwardForeignKey = noDerivedSourceColumns && noDerivedTargetColumns && statisticProvider.isForeignKey(sourceTable, sourceColumns, targetTable, targetColumns) && statisticProvider.isKey(targetTable, targetColumns);
        boolean bl = backwardForeignKey = noDerivedSourceColumns && noDerivedTargetColumns && statisticProvider.isForeignKey(targetTable, targetColumns, sourceTable, sourceColumns) && statisticProvider.isKey(sourceTable, sourceColumns);
        if (backwardForeignKey != forwardForeignKey) {
            return backwardForeignKey;
        }
        return Step.compare(sourceTable, sourceColumns, targetTable, targetColumns) < 0;
    }

    private static int compare(RelOptTable table1, List<Integer> columns1, RelOptTable table2, List<Integer> columns2) {
        int c = Ordering.natural().lexicographical().compare(table1.getQualifiedName(), table2.getQualifiedName());
        if (c == 0) {
            c = Ordering.natural().lexicographical().compare(columns1, columns2);
        }
        return c;
    }

    private static double cardinality(SqlStatisticProvider statisticProvider, LatticeTable table) {
        return statisticProvider.tableCardinality(table.t);
    }

    static class Factory
    implements AttributedDirectedGraph.AttributedEdgeFactory<LatticeTable, Step> {
        @NotOnlyInitialized
        private final LatticeSpace space;

        Factory(@UnderInitialization LatticeSpace space) {
            this.space = Objects.requireNonNull(space, "space");
        }

        @Override
        public Step createEdge(LatticeTable source, LatticeTable target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Step createEdge(LatticeTable source, LatticeTable target, Object ... attributes) {
            List keys = (List)attributes[0];
            return Step.create(source, target, keys, this.space);
        }
    }
}

