/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.materialize;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.Iterables;
import com.hazelcast.org.apache.calcite.DataContexts;
import com.hazelcast.org.apache.calcite.materialize.CachingLatticeStatisticProvider;
import com.hazelcast.org.apache.calcite.materialize.Lattice;
import com.hazelcast.org.apache.calcite.materialize.LatticeStatisticProvider;
import com.hazelcast.org.apache.calcite.materialize.MaterializationService;
import com.hazelcast.org.apache.calcite.schema.ScannableTable;
import com.hazelcast.org.apache.calcite.schema.Table;
import com.hazelcast.org.apache.calcite.schema.impl.MaterializedViewTable;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class SqlLatticeStatisticProvider
implements LatticeStatisticProvider {
    static final LatticeStatisticProvider.Factory FACTORY = SqlLatticeStatisticProvider::new;
    static final LatticeStatisticProvider.Factory CACHED_FACTORY = lattice -> {
        LatticeStatisticProvider provider = (LatticeStatisticProvider)FACTORY.apply(lattice);
        return new CachingLatticeStatisticProvider((Lattice)lattice, provider);
    };
    private final Lattice lattice;

    private SqlLatticeStatisticProvider(Lattice lattice) {
        this.lattice = Objects.requireNonNull(lattice, "lattice");
    }

    @Override
    public double cardinality(List<Lattice.Column> columns) {
        ArrayList<Double> counts = new ArrayList<Double>();
        for (Lattice.Column column : columns) {
            counts.add(SqlLatticeStatisticProvider.cardinality(this.lattice, column));
        }
        return (int)Lattice.getRowCount(this.lattice.getFactRowCount(), counts);
    }

    private static double cardinality(Lattice lattice, Lattice.Column column) {
        String sql = lattice.countSql(ImmutableBitSet.of(column.ordinal));
        Table table = new MaterializationService.DefaultTableFactory().createTable(lattice.rootSchema, sql, ImmutableList.of());
        @Nullable Object[] values = Iterables.getOnlyElement(((ScannableTable)table).scan(DataContexts.of(MaterializedViewTable.MATERIALIZATION_CONNECTION, lattice.rootSchema.plus())));
        Number value = (Number)values[0];
        Objects.requireNonNull(value, () -> "count(*) produced null in " + sql);
        return value.doubleValue();
    }
}

