/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.linq4j.tree;

import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionType;
import com.hazelcast.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.org.apache.calcite.linq4j.tree.ParameterExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.org.apache.calcite.linq4j.tree.Statement;
import com.hazelcast.org.apache.calcite.linq4j.tree.Visitor;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class DeclarationStatement
extends Statement {
    public final int modifiers;
    public final ParameterExpression parameter;
    public final @Nullable Expression initializer;

    public DeclarationStatement(int modifiers, ParameterExpression parameter, @Nullable Expression initializer) {
        super(ExpressionType.Declaration, Void.TYPE);
        assert (parameter != null) : "parameter should not be null";
        this.modifiers = modifiers;
        this.parameter = parameter;
        this.initializer = initializer;
    }

    @Override
    public DeclarationStatement accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression initializer = this.initializer != null ? this.initializer.accept(shuttle) : null;
        return shuttle.visit(this, initializer);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept0(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(modifiers).append(' ');
        }
        writer.append(this.parameter.type).append(' ').append(this.parameter.name);
        if (this.initializer != null) {
            writer.append(" = ").append(this.initializer);
        }
        writer.append(';');
        writer.newlineAndIndent();
    }

    public void accept2(ExpressionWriter writer, boolean withType) {
        if (withType) {
            String modifiers = Modifier.toString(this.modifiers);
            if (!modifiers.isEmpty()) {
                writer.append(modifiers).append(' ');
            }
            writer.append(this.parameter.type).append(' ');
        } else {
            writer.append(", ");
        }
        writer.append(this.parameter.name);
        if (this.initializer != null) {
            writer.append(" = ").append(this.initializer);
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeclarationStatement that = (DeclarationStatement)o;
        if (this.modifiers != that.modifiers) {
            return false;
        }
        if (this.initializer != null ? !this.initializer.equals(that.initializer) : that.initializer != null) {
            return false;
        }
        return this.parameter.equals(that.parameter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.modifiers, this.parameter, this.initializer});
    }
}

