/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.interpreter;

import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.Arrays;

public class Row {
    private final @Nullable Object[] values;

    Row(@Nullable Object[] values) {
        this.values = values;
    }

    public static Row asCopy(Object ... values) {
        return new Row((Object[])values.clone());
    }

    public static Row of(@Nullable Object value0) {
        return new Row(new Object[]{value0});
    }

    public static Row of(@Nullable Object value0, @Nullable Object value1) {
        return new Row(new Object[]{value0, value1});
    }

    public static Row of(@Nullable Object value0, @Nullable Object value1, @Nullable Object value2) {
        return new Row(new Object[]{value0, value1, value2});
    }

    public static Row of(Object ... values) {
        return new Row(values);
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(@Nullable Object obj) {
        return obj == this || obj instanceof Row && Arrays.equals(this.values, ((Row)obj).values);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    public @Nullable Object getObject(int index) {
        return this.values[index];
    }

    @Nullable Object[] getValues() {
        return this.values;
    }

    public @Nullable Object[] copyValues() {
        return (Object[])this.values.clone();
    }

    public int size() {
        return this.values.length;
    }

    public static RowBuilder newBuilder(int size) {
        return new RowBuilder(size);
    }

    public static class RowBuilder {
        @Nullable Object[] values;

        private RowBuilder(int size) {
            this.values = new Object[size];
        }

        public void set(int index, @Nullable Object value) {
            this.values[index] = value;
        }

        public Row build() {
            return new Row(this.values);
        }

        public void reset() {
            this.values = new Object[this.values.length];
        }

        public int size() {
            return this.values.length;
        }
    }
}

