/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableUnion;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;
import com.hazelcast.org.apache.calcite.rel.core.Union;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalUnion;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.List;

class EnumerableUnionRule
extends ConverterRule {
    static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalUnion.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableUnionRule").withRuleFactory(EnumerableUnionRule::new);

    protected EnumerableUnionRule(ConverterRule.Config config) {
        super(config);
    }

    @Override
    public RelNode convert(RelNode rel) {
        Union union = (Union)rel;
        EnumerableConvention out = EnumerableConvention.INSTANCE;
        RelTraitSet traitSet = rel.getCluster().traitSet().replace(out);
        List<RelNode> newInputs = Util.transform(union.getInputs(), n -> EnumerableUnionRule.convert(n, traitSet));
        return new EnumerableUnion(rel.getCluster(), traitSet, newInputs, union.all);
    }
}

