/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysType;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.org.apache.calcite.interpreter.Interpreter;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.SingleRel;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class EnumerableInterpreter
extends SingleRel
implements EnumerableRel {
    private final double factor;

    public EnumerableInterpreter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, double factor) {
        super(cluster, traitSet, input);
        assert (this.getConvention() instanceof EnumerableConvention);
        this.factor = factor;
    }

    public static EnumerableInterpreter create(RelNode input, double factor) {
        RelTraitSet traitSet = input.getTraitSet().replace(EnumerableConvention.INSTANCE);
        return new EnumerableInterpreter(input.getCluster(), traitSet, input, factor);
    }

    @Override
    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = super.computeSelfCost(planner, mq);
        if (cost == null) {
            return null;
        }
        return cost.multiplyBy(this.factor);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableInterpreter(this.getCluster(), traitSet, EnumerableInterpreter.sole(inputs), this.factor);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), JavaRowFormat.ARRAY);
        Expression interpreter_ = builder.append("interpreter", Expressions.new_(Interpreter.class, new Expression[]{implementor.getRootExpression(), implementor.stash(this.getInput(), RelNode.class)}));
        Expression sliced_ = this.getRowType().getFieldCount() == 1 ? Expressions.call(BuiltInMethod.SLICE0.method, interpreter_) : interpreter_;
        builder.add(sliced_);
        return implementor.result(physType, builder.toBlock());
    }
}

