/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.com.google.common.cache.Cache;
import com.hazelcast.com.google.common.cache.CacheBuilder;
import com.hazelcast.org.apache.calcite.DataContext;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.org.apache.calcite.avatica.Helper;
import com.hazelcast.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.org.apache.calcite.interpreter.Compiler;
import com.hazelcast.org.apache.calcite.interpreter.InterpretableConvention;
import com.hazelcast.org.apache.calcite.interpreter.InterpretableRel;
import com.hazelcast.org.apache.calcite.interpreter.Node;
import com.hazelcast.org.apache.calcite.interpreter.Row;
import com.hazelcast.org.apache.calcite.interpreter.Sink;
import com.hazelcast.org.apache.calcite.linq4j.AbstractEnumerable;
import com.hazelcast.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.org.apache.calcite.linq4j.tree.ClassDeclaration;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.FieldDeclaration;
import com.hazelcast.org.apache.calcite.linq4j.tree.VisitorImpl;
import com.hazelcast.org.apache.calcite.plan.ConventionTraitDef;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterImpl;
import com.hazelcast.org.apache.calcite.runtime.ArrayBindable;
import com.hazelcast.org.apache.calcite.runtime.Bindable;
import com.hazelcast.org.apache.calcite.runtime.Hook;
import com.hazelcast.org.apache.calcite.runtime.Typed;
import com.hazelcast.org.apache.calcite.runtime.Utilities;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.org.codehaus.commons.compiler.CompileException;
import com.hazelcast.org.codehaus.commons.compiler.CompilerFactoryFactory;
import com.hazelcast.org.codehaus.commons.compiler.IClassBodyEvaluator;
import com.hazelcast.org.codehaus.commons.compiler.ICompilerFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

public class EnumerableInterpretable
extends ConverterImpl
implements InterpretableRel {
    private static final Cache<String, Bindable> BINDABLE_CACHE = CacheBuilder.newBuilder().concurrencyLevel(CalciteSystemProperty.BINDABLE_CACHE_CONCURRENCY_LEVEL.value()).maximumSize(CalciteSystemProperty.BINDABLE_CACHE_MAX_SIZE.value().intValue()).build();

    protected EnumerableInterpretable(RelOptCluster cluster, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, cluster.traitSetOf((RelTrait)InterpretableConvention.INSTANCE), input);
    }

    @Override
    public EnumerableInterpretable copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableInterpretable(this.getCluster(), EnumerableInterpretable.sole(inputs));
    }

    @Override
    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        Bindable bindable = EnumerableInterpretable.toBindable(implementor.internalParameters, implementor.spark, (EnumerableRel)this.getInput(), EnumerableRel.Prefer.ARRAY);
        ArrayBindable arrayBindable = EnumerableInterpretable.box(bindable);
        Enumerable<@Nullable Object[]> enumerable = arrayBindable.bind(implementor.dataContext);
        return new EnumerableNode(enumerable, implementor.compiler, this);
    }

    public static Bindable toBindable(Map<String, Object> parameters,  @Nullable CalcitePrepare.SparkHandler spark, EnumerableRel rel, EnumerableRel.Prefer prefer) {
        EnumerableRelImplementor relImplementor = new EnumerableRelImplementor(rel.getCluster().getRexBuilder(), parameters);
        ClassDeclaration expr = relImplementor.implementRoot(rel, prefer);
        String s2 = Expressions.toString(expr.memberDeclarations, "\n", false);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, s2);
        }
        Hook.JAVA_PLAN.run(s2);
        try {
            if (spark != null && spark.enabled()) {
                return spark.compile(expr, s2);
            }
            return EnumerableInterpretable.getBindable(expr, s2, rel.getRowType().getFieldCount());
        }
        catch (Exception e) {
            throw Helper.INSTANCE.wrap("Error while compiling generated Java code:\n" + s2, e);
        }
    }

    static Bindable getBindable(ClassDeclaration expr, String s2, int fieldCount) throws CompileException, IOException, ExecutionException {
        Class[] classArray;
        ICompilerFactory compilerFactory;
        ClassLoader classLoader = Objects.requireNonNull(EnumerableInterpretable.class.getClassLoader(), "classLoader");
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory(classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
        cbe.setClassName(expr.name);
        cbe.setExtendedClass(Utilities.class);
        if (fieldCount == 1) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = Bindable.class;
            classArray = classArray2;
            classArray2[1] = Typed.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = ArrayBindable.class;
        }
        cbe.setImplementedInterfaces(classArray);
        cbe.setParentClassLoader(classLoader);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            cbe.setDebuggingInformation(true, true, true);
        }
        if (CalciteSystemProperty.BINDABLE_CACHE_MAX_SIZE.value() != 0) {
            StaticFieldDetector detector = new StaticFieldDetector();
            expr.accept(detector);
            if (!detector.containsStaticField) {
                return BINDABLE_CACHE.get(s2, () -> (Bindable)cbe.createInstance(new StringReader(s2)));
            }
        }
        return (Bindable)cbe.createInstance(new StringReader(s2));
    }

    static ArrayBindable box(final Bindable bindable) {
        if (bindable instanceof ArrayBindable) {
            return (ArrayBindable)bindable;
        }
        return new ArrayBindable(){

            @Override
            public Class<Object[]> getElementType() {
                return Object[].class;
            }

            @Override
            public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
                final Enumerable enumerable = bindable.bind(dataContext);
                return new AbstractEnumerable<Object[]>(){

                    @Override
                    public Enumerator<@Nullable Object[]> enumerator() {
                        final Enumerator enumerator = enumerable.enumerator();
                        return new Enumerator<Object[]>(){

                            @Override
                            public @Nullable Object[] current() {
                                return new Object[]{enumerator.current()};
                            }

                            @Override
                            public boolean moveNext() {
                                return enumerator.moveNext();
                            }

                            @Override
                            public void reset() {
                                enumerator.reset();
                            }

                            @Override
                            public void close() {
                                enumerator.close();
                            }
                        };
                    }
                };
            }
        };
    }

    private static class EnumerableNode
    implements Node {
        private final Enumerable<@Nullable Object[]> enumerable;
        private final Sink sink;

        EnumerableNode(Enumerable<@Nullable Object[]> enumerable, Compiler compiler, EnumerableInterpretable rel) {
            this.enumerable = enumerable;
            this.sink = compiler.sink(rel);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void run() throws InterruptedException {
            Enumerator<@Nullable T> enumerator = this.enumerable.enumerator();
            while (enumerator.moveNext()) {
                @Nullable Object[] values = (Object[])enumerator.current();
                this.sink.send(Row.of(values));
            }
        }
    }

    static class StaticFieldDetector
    extends VisitorImpl<Void> {
        boolean containsStaticField = false;

        StaticFieldDetector() {
        }

        @Override
        public Void visit(FieldDeclaration fieldDeclaration) {
            this.containsStaticField = (fieldDeclaration.modifier & 8) != 0;
            return this.containsStaticField ? null : (Void)super.visit(fieldDeclaration);
        }
    }
}

