/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysType;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Collect;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;

public class EnumerableCollect
extends Collect
implements EnumerableRel {
    public EnumerableCollect(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType rowType) {
        super(cluster, traitSet, input, rowType);
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() == input.getConvention());
    }

    @Deprecated
    public EnumerableCollect(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, String fieldName) {
        this(cluster, traitSet, input, EnumerableCollect.deriveRowType(cluster.getTypeFactory(), SqlTypeName.MULTISET, fieldName, input.getRowType()));
    }

    public static Collect create(RelNode input, RelDataType rowType) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSet().replace(EnumerableConvention.INSTANCE);
        return new EnumerableCollect(cluster, traitSet, input, rowType);
    }

    @Override
    public EnumerableCollect copy(RelTraitSet traitSet, RelNode newInput) {
        return new EnumerableCollect(this.getCluster(), traitSet, newInput, this.rowType());
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, EnumerableRel.Prefer.ARRAY);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), JavaRowFormat.LIST);
        Expression child_ = builder.append("child", result.block);
        Expression conv_ = builder.append("converted", result.physType.convertTo(child_, JavaRowFormat.ARRAY));
        Expression list_ = builder.append("list", Expressions.call(conv_, BuiltInMethod.ENUMERABLE_TO_LIST.method, new Expression[0]));
        builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.SINGLETON_ENUMERABLE.method, list_)));
        return implementor.result(physType, builder.toBlock());
    }
}

