/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.special;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastObjectTypeReference;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.Pair;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;

public class HazelcastToRowFunction
extends HazelcastFunction {
    public static final HazelcastFunction INSTANCE = new HazelcastToRowFunction();

    public HazelcastToRowFunction() {
        super("TO_ROW", SqlKind.OTHER_FUNCTION, null, new ReplaceUnknownOperandTypeInference(SqlTypeName.ANY), SqlFunctionCategory.SYSTEM);
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        return callBinding.getOperandType(0) instanceof HazelcastObjectTypeReference;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        final HazelcastObjectTypeReference operandType = (HazelcastObjectTypeReference)opBinding.getOperandType(0);
        RelDataType recordType = typeFactory.createStructType((List<? extends Map.Entry<String, RelDataType>>)new AbstractList<Map.Entry<String, RelDataType>>(){

            @Override
            public Map.Entry<String, RelDataType> get(int index) {
                RelDataTypeField field = operandType.getFieldList().get(index);
                return Pair.of(field.getName(), field.getType());
            }

            @Override
            public int size() {
                return operandType.getFieldCount();
            }
        });
        boolean nullable = recordType.getFieldList().stream().allMatch(f -> f.getType().isNullable());
        return typeFactory.createTypeWithNullability(recordType, nullable);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(1);
    }
}

