/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.json;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.MultiTypeOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operand.OperandCheckerProgram;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.JsonFunctionOperandTypeInference;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlJsonValueReturning;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;

public class HazelcastJsonValueFunction
extends HazelcastFunction {
    public static final HazelcastJsonValueFunction INSTANCE = new HazelcastJsonValueFunction();

    public HazelcastJsonValueFunction() {
        super("JSON_VALUE", SqlKind.OTHER_FUNCTION, new JsonValueFunctionReturnTypeInference(), new JsonFunctionOperandTypeInference(), SqlFunctionCategory.SYSTEM);
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        return new OperandCheckerProgram(MultiTypeOperandChecker.JSON_OR_VARCHAR, TypedOperandChecker.VARCHAR).check(callBinding, throwOnFailure);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(2);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep(",", true);
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        for (int i = 2; i < call.operandCount(); ++i) {
            ((SqlNode)call.operand(i)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }

    private static final class JsonValueFunctionReturnTypeInference
    implements SqlReturnTypeInference {
        private JsonValueFunctionReturnTypeInference() {
        }

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding binding) {
            Object value;
            if (binding.getOperandCount() >= 4 && binding.getOperandType(2).getSqlTypeName() == SqlTypeName.SYMBOL && (value = ((SqlLiteral)((SqlCallBinding)binding).getCall().operand(2)).getValue()) == SqlJsonValueReturning.RETURNING) {
                return binding.getOperandType(3);
            }
            return binding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
        }
    }
}

