/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.common;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import java.util.Arrays;

public interface HazelcastOperandTypeCheckerAware {
    default public HazelcastCallBinding prepareBinding(SqlCallBinding binding) {
        SqlOperator operator = binding.getOperator();
        if (!1.$assertionsDisabled && operator != this) {
            throw new AssertionError();
        }
        SqlOperandTypeInference operandTypeInference = operator.getOperandTypeInference();
        return this.prepareBinding(binding, operandTypeInference);
    }

    default public HazelcastCallBinding prepareBinding(SqlCallBinding binding, SqlOperandTypeInference operandTypeInference) {
        HazelcastSqlValidator validator = (HazelcastSqlValidator)binding.getValidator();
        boolean resolveOperands = false;
        for (int i = 0; i < binding.getOperandCount(); ++i) {
            RelDataType operandType = binding.getOperandType(i);
            if (!HazelcastTypeUtils.isNullOrUnknown(operandType.getSqlTypeName())) continue;
            resolveOperands = true;
            break;
        }
        if (resolveOperands) {
            RelDataType unknownType = binding.getValidator().getUnknownType();
            Object[] operandTypes = new RelDataType[binding.getOperandCount()];
            Arrays.fill(operandTypes, unknownType);
            operandTypeInference.inferOperandTypes(binding, binding.getValidator().getUnknownType(), (RelDataType[])operandTypes);
            for (int i = 0; i < binding.getOperandCount(); ++i) {
                validator.setValidatedNodeType((SqlNode)binding.getCall().operand(i), (RelDataType)operandTypes[i]);
            }
        }
        return new HazelcastCallBinding(binding);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

