/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableFunctionParameter;
import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.jet.sql.impl.validate.operand.NamedOperandCheckerProgram;
import com.hazelcast.jet.sql.impl.validate.operand.OperandChecker;
import com.hazelcast.jet.sql.impl.validate.operand.OperandCheckerProgram;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastOperandTypeCheckerAware;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandMetadata;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import java.util.List;
import javax.annotation.Nullable;

public abstract class HazelcastSqlOperandMetadata
implements SqlOperandMetadata,
HazelcastOperandTypeCheckerAware {
    private final List<HazelcastTableFunctionParameter> parameters;
    private final SqlOperandTypeInference operandTypeInference;

    public HazelcastSqlOperandMetadata(List<HazelcastTableFunctionParameter> parameters) {
        this(parameters, null);
    }

    public HazelcastSqlOperandMetadata(List<HazelcastTableFunctionParameter> parameters, SqlOperandTypeInference operandTypeInference) {
        this.parameters = parameters;
        this.operandTypeInference = operandTypeInference;
    }

    public final List<HazelcastTableFunctionParameter> parameters() {
        return this.parameters;
    }

    @Override
    public final List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public final List<String> paramNames() {
        return Util.toList(this.parameters, HazelcastTableFunctionParameter::name);
    }

    @Override
    public final boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        boolean checkResult;
        HazelcastCallBinding binding = this.prepareBinding(callBinding, this.operandTypeInference);
        if (ValidationUtil.hasAssignment(binding.getCall())) {
            OperandChecker[] checkers = (OperandChecker[])this.parameters.stream().map(HazelcastTableFunctionParameter::checker).toArray(OperandChecker[]::new);
            checkResult = new NamedOperandCheckerProgram(checkers).check(binding, throwOnFailure);
        } else {
            OperandChecker[] checkers = (OperandChecker[])this.parameters.stream().limit(binding.getOperandCount()).map(HazelcastTableFunctionParameter::checker).toArray(OperandChecker[]::new);
            checkResult = new OperandCheckerProgram(checkers).check(binding, throwOnFailure);
        }
        return checkResult && this.checkOperandTypes(binding, throwOnFailure);
    }

    protected abstract boolean checkOperandTypes(HazelcastCallBinding var1, boolean var2);

    @Override
    public final SqlOperandCountRange getOperandCountRange() {
        int numberOfOptionalParameters = (int)this.parameters.stream().filter(HazelcastTableFunctionParameter::optional).count();
        return SqlOperandCountRanges.between(this.parameters.size() - numberOfOptionalParameters, this.parameters.size());
    }

    @Override
    public final String getAllowedSignatures(SqlOperator operator, String operatorName) {
        throw new UnsupportedOperationException("Should not be called");
    }

    @Override
    public final SqlOperandTypeChecker.Consistency getConsistency() {
        return SqlOperandTypeChecker.Consistency.NONE;
    }

    @Override
    public final boolean isOptional(int i) {
        return this.parameters.get(i).optional();
    }

    @Override
    @Nullable
    public final SqlOperandTypeInference typeInference() {
        return this.operandTypeInference;
    }
}

