/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.jet.sql.impl.connector.virtual.ViewTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastRelOptTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastViewRelOptTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastJsonType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.org.apache.calcite.jdbc.CalciteSchema;
import com.hazelcast.org.apache.calcite.prepare.CalciteCatalogReader;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlNameMatchers;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorTable;
import java.util.List;

public class HazelcastCalciteCatalogReader
extends CalciteCatalogReader {
    public HazelcastCalciteCatalogReader(CalciteSchema rootSchema, List<List<String>> schemaPaths, RelDataTypeFactory typeFactory, CalciteConnectionConfig config) {
        super(rootSchema, SqlNameMatchers.withCaseSensitive(config != null && config.caseSensitive()), schemaPaths, typeFactory, config);
    }

    @Override
    public Prepare.PreparingTable getTable(List<String> names) {
        SqlValidatorTable table = super.getTable((List)names);
        if (table == null) {
            return null;
        }
        HazelcastTable hzTable = table.unwrap(HazelcastTable.class);
        assert (hzTable != null);
        if (hzTable.getTarget() instanceof ViewTable) {
            return new HazelcastViewRelOptTable((Prepare.PreparingTable)table, ((ViewTable)((Object)hzTable.getTarget())).getViewRel());
        }
        return new HazelcastRelOptTable((Prepare.PreparingTable)table);
    }

    @Override
    public RelDataType getNamedType(SqlIdentifier typeName) {
        if (HazelcastTypeUtils.isObjectIdentifier(typeName)) {
            return this.typeFactory.createSqlType(SqlTypeName.ANY);
        }
        if (HazelcastTypeUtils.isJsonIdentifier(typeName)) {
            return HazelcastJsonType.create(true);
        }
        return super.getNamedType(typeName);
    }
}

