/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.jet.sql.impl.QueryResultProducerImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.EmptyRow;
import com.hazelcast.sql.impl.row.Row;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import javax.annotation.Nonnull;

public final class RootResultConsumerSink
implements Processor {
    private final Expression<?> limitExpression;
    private final Expression<?> offsetExpression;
    private QueryResultProducerImpl rootResultConsumer;

    private RootResultConsumerSink(Expression<?> limitExpression, Expression<?> offsetExpression) {
        this.limitExpression = limitExpression;
        this.offsetExpression = offsetExpression;
    }

    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) {
        this.rootResultConsumer = (QueryResultProducerImpl)Util.getNodeEngine((HazelcastInstance)context.hazelcastInstance()).getSqlService().getInternalService().getResultRegistry().remove(context.jobId());
        assert (this.rootResultConsumer != null);
        ExpressionEvalContext evalContext = ExpressionEvalContext.from((ProcessorSupplier.Context)context);
        Number limit = RootResultConsumerSink.evaluate(this.limitExpression, evalContext);
        if (limit == null) {
            throw QueryException.error((String)"LIMIT value cannot be null");
        }
        if (limit.longValue() < 0L) {
            throw QueryException.error((String)("LIMIT value cannot be negative: " + limit));
        }
        Number offset = RootResultConsumerSink.evaluate(this.offsetExpression, evalContext);
        if (offset == null) {
            throw QueryException.error((String)"OFFSET value cannot be null");
        }
        if (offset.longValue() < 0L) {
            throw QueryException.error((String)("OFFSET value cannot be negative: " + offset));
        }
        this.rootResultConsumer.init(limit.longValue(), offset.longValue());
    }

    private static Number evaluate(Expression<?> expression, ExpressionEvalContext evalContext) {
        return (Number)expression.eval((Row)EmptyRow.INSTANCE, evalContext);
    }

    public boolean tryProcess() {
        try {
            this.rootResultConsumer.ensureNotDone();
        }
        catch (QueryException e) {
            if (e.getCode() == 1003) {
                throw new CancellationException();
            }
            throw e;
        }
        return true;
    }

    public void process(int ordinal, @Nonnull Inbox inbox) {
        try {
            this.rootResultConsumer.consume(inbox);
        }
        catch (QueryException e) {
            if (e.getCode() == 1003) {
                throw new CancellationException();
            }
            throw e;
        }
    }

    public boolean complete() {
        this.rootResultConsumer.done();
        return true;
    }

    public boolean closeIsCooperative() {
        return true;
    }

    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    public static ProcessorMetaSupplier rootResultConsumerSink(Address initiatorAddress, Expression<?> limitExpression, Expression<?> offsetExpression) {
        ProcessorSupplier pSupplier = ProcessorSupplier.of((SupplierEx)new Supplier(limitExpression, offsetExpression));
        return ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)pSupplier, (Address)initiatorAddress);
    }

    public static class Supplier
    implements SupplierEx<Processor>,
    IdentifiedDataSerializable {
        private Expression<?> limitExpression;
        private Expression<?> offsetExpression;

        public Supplier(Expression<?> limitExpression, Expression<?> offsetExpression) {
            this.limitExpression = limitExpression;
            this.offsetExpression = offsetExpression;
        }

        public Supplier() {
        }

        public Processor getEx() {
            return new RootResultConsumerSink(this.limitExpression, this.offsetExpression);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject(this.limitExpression);
            out.writeObject(this.offsetExpression);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.limitExpression = (Expression)in.readObject();
            this.offsetExpression = (Expression)in.readObject();
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 8;
        }
    }
}

