/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.org.apache.calcite.sql.SqlDrop;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlDropView
extends SqlDrop {
    private static final SqlSpecialOperator DROP_VIEW = new SqlSpecialOperator("DROP VIEW", SqlKind.DROP_VIEW);
    private final SqlIdentifier viewName;

    public SqlDropView(SqlIdentifier name, boolean ifExists, SqlParserPos pos) {
        super(DROP_VIEW, pos, ifExists);
        this.viewName = Objects.requireNonNull(name, "View name should not be null");
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public String viewName() {
        return this.viewName.toString();
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return DROP_VIEW;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.viewName);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP VIEW");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.viewName.unparse(writer, leftPrec, rightPrec);
    }
}

