/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical.visitor;

import com.hazelcast.jet.sql.impl.opt.physical.visitor.RexToExpression;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexCorrelVariable;
import com.hazelcast.org.apache.calcite.rex.RexDynamicParam;
import com.hazelcast.org.apache.calcite.rex.RexFieldAccess;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexLocalRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexOver;
import com.hazelcast.org.apache.calcite.rex.RexPatternFieldRef;
import com.hazelcast.org.apache.calcite.rex.RexRangeRef;
import com.hazelcast.org.apache.calcite.rex.RexSubQuery;
import com.hazelcast.org.apache.calcite.rex.RexTableInputRef;
import com.hazelcast.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.FieldAccessExpression;
import com.hazelcast.sql.impl.expression.ParameterExpression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;

public final class RexToExpressionVisitor
implements RexVisitor<Expression<?>> {
    private static final Expression<?>[] EMPTY_EXPRESSION_OPERANDS = new Expression[0];
    private final PlanNodeFieldTypeProvider fieldTypeProvider;
    private final QueryParameterMetadata parameterMetadata;

    public RexToExpressionVisitor(PlanNodeFieldTypeProvider fieldTypeProvider, QueryParameterMetadata parameterMetadata) {
        this.fieldTypeProvider = fieldTypeProvider;
        this.parameterMetadata = parameterMetadata;
    }

    @Override
    public Expression<?> visitInputRef(RexInputRef inputRef) {
        int index = inputRef.getIndex();
        return ColumnExpression.create((int)index, (QueryDataType)this.fieldTypeProvider.getType(index));
    }

    @Override
    public Expression<?> visitLocalRef(RexLocalRef localRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression<?> visitLiteral(RexLiteral literal) {
        return RexToExpression.convertLiteral(literal);
    }

    @Override
    public Expression<?> visitCall(RexCall call) {
        Expression<?>[] expressionOperands;
        List<RexNode> rexOperands = call.getOperands();
        if (rexOperands == null || rexOperands.isEmpty()) {
            expressionOperands = EMPTY_EXPRESSION_OPERANDS;
        } else {
            expressionOperands = new Expression[rexOperands.size()];
            for (int i = 0; i < rexOperands.size(); ++i) {
                Expression expressionOperand;
                expressionOperands[i] = expressionOperand = (Expression)rexOperands.get(i).accept(this);
            }
        }
        return RexToExpression.convertCall(call, expressionOperands);
    }

    @Override
    public Expression<?> visitOver(RexOver over) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression<?> visitCorrelVariable(RexCorrelVariable correlVariable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression<?> visitDynamicParam(RexDynamicParam dynamicParam) {
        int index = dynamicParam.getIndex();
        return ParameterExpression.create((int)index, (QueryDataType)this.parameterMetadata.getParameterConverter(index).getTargetType());
    }

    @Override
    public Expression<?> visitRangeRef(RexRangeRef rangeRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression<?> visitFieldAccess(RexFieldAccess fieldAccess) {
        Expression referenceExpression = (Expression)fieldAccess.getReferenceExpr().accept(this);
        return FieldAccessExpression.create((QueryDataType)HazelcastTypeUtils.toHazelcastType(fieldAccess.getType()), (String)fieldAccess.getField().getName(), (Expression)referenceExpression);
    }

    @Override
    public Expression<?> visitSubQuery(RexSubQuery subQuery) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression<?> visitTableInputRef(RexTableInputRef fieldRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression<?> visitPatternFieldRef(RexPatternFieldRef fieldRef) {
        throw new UnsupportedOperationException();
    }
}

