/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.ImmutableStreamingInsertMustNotExecuteRule;
import com.hazelcast.jet.sql.impl.opt.physical.MustNotExecutePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SinkPhysicalRel;
import com.hazelcast.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import org.immutables.value.Value;

@Value.Enclosing
public final class StreamingInsertMustNotExecuteRule
extends RelRule<RelRule.Config>
implements TransformationRule {
    public static final RelOptRule INSTANCE = new StreamingInsertMustNotExecuteRule(Config.DEFAULT);

    private StreamingInsertMustNotExecuteRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        SinkPhysicalRel sinkRel = (SinkPhysicalRel)call.rel(0);
        HazelcastRelOptCluster cluster = (HazelcastRelOptCluster)sinkRel.getCluster();
        if (!cluster.requiresJob()) {
            call.transformTo(new MustNotExecutePhysicalRel(sinkRel.getCluster(), sinkRel.getTraitSet(), sinkRel.getRowType(), "You must use CREATE JOB statement for a streaming DML query"));
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableStreamingInsertMustNotExecuteRule.Config.builder().description(StreamingInsertMustNotExecuteRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(SinkPhysicalRel.class).predicate(OptUtils::isUnbounded).anyInputs()).build();

        @Override
        default public RelOptRule toRule() {
            return new StreamingInsertMustNotExecuteRule(this);
        }
    }
}

