/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.aggregate.WindowUtils;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.CreateDagVisitor;
import com.hazelcast.jet.sql.impl.opt.physical.JoinPhysicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinInfo;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StreamToStreamJoinPhysicalRel
extends JoinPhysicalRel {
    private final Map<Integer, Map<Integer, Long>> postponeTimeMap;

    protected StreamToStreamJoinPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Map<Integer, Map<Integer, Long>> postponeTimeMap) {
        super(cluster, traitSet, left, right, condition, joinType);
        this.postponeTimeMap = postponeTimeMap;
    }

    public JetJoinInfo joinInfo(QueryParameterMetadata parameterMetadata) {
        JoinInfo joinInfo = this.analyzeCondition();
        RexNode predicate = joinInfo.getRemaining(this.getCluster().getRexBuilder());
        Expression<Boolean> nonEquiCondition = this.filter((PlanNodeFieldTypeProvider)this.schema(parameterMetadata), predicate, parameterMetadata);
        Expression<Boolean> condition = this.filter((PlanNodeFieldTypeProvider)this.schema(parameterMetadata), this.getCondition(), parameterMetadata);
        return new JetJoinInfo(this.getJoinType(), joinInfo.leftKeys.toIntArray(), joinInfo.rightKeys.toIntArray(), nonEquiCondition, condition);
    }

    public Map<Integer, ToLongFunctionEx<JetSqlRow>> leftTimeExtractors() {
        return this.timeExtractors(this.getLeft());
    }

    public Map<Integer, ToLongFunctionEx<JetSqlRow>> rightTimeExtractors() {
        return this.timeExtractors(this.getRight());
    }

    private Map<Integer, ToLongFunctionEx<JetSqlRow>> timeExtractors(RelNode input) {
        HashMap<Integer, ToLongFunctionEx<JetSqlRow>> timeExtractors = new HashMap<Integer, ToLongFunctionEx<JetSqlRow>>();
        for (Integer i : OptUtils.metadataQuery(this).extractWatermarkedFields(input).getFieldIndexes()) {
            timeExtractors.put(i, (ToLongFunctionEx<JetSqlRow>)(ToLongFunctionEx & Serializable)row -> WindowUtils.extractMillis(row.getRow().get(i.intValue())));
        }
        return timeExtractors;
    }

    public Map<Integer, Map<Integer, Long>> postponeTimeMap() {
        return this.postponeTimeMap;
    }

    @Override
    public Vertex accept(CreateDagVisitor visitor) {
        return visitor.onStreamToStreamJoin(this);
    }

    @Override
    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new StreamToStreamJoinPhysicalRel(this.getCluster(), traitSet, left, right, this.getCondition(), joinType, this.postponeTimeMap);
    }
}

