/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.SortLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SortPhysicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import java.util.ArrayList;
import java.util.List;

final class SortPhysicalRule
extends RelOptRule {
    static final RelOptRule INSTANCE = new SortPhysicalRule();

    private SortPhysicalRule() {
        super(SortPhysicalRule.operand(SortLogicalRel.class, Conventions.LOGICAL, SortPhysicalRule.some(SortPhysicalRule.operand(RelNode.class, SortPhysicalRule.any()), new RelOptRuleOperand[0])), SortPhysicalRule.class.getSimpleName());
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        SortLogicalRel logicalSort = (SortLogicalRel)call.rel(0);
        List<RelNode> transforms = SortPhysicalRule.toTransforms(logicalSort);
        for (RelNode transform : transforms) {
            call.transformTo(transform);
        }
    }

    private static List<RelNode> toTransforms(SortLogicalRel logicalSort) {
        ArrayList<SortPhysicalRel> sortTransforms = new ArrayList<SortPhysicalRel>(1);
        ArrayList<RelNode> nonSortTransforms = new ArrayList<RelNode>(1);
        for (RelNode physicalInput : OptUtils.extractPhysicalRelsFromSubset(logicalSort.getInput())) {
            boolean requiresSort = SortPhysicalRule.requiresSort(logicalSort.getCollation(), physicalInput.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE));
            if (requiresSort || logicalSort.offset != null || logicalSort.fetch != null) {
                sortTransforms.add(SortPhysicalRule.createSort(logicalSort, physicalInput, requiresSort));
                continue;
            }
            nonSortTransforms.add(physicalInput);
        }
        return !nonSortTransforms.isEmpty() ? nonSortTransforms : sortTransforms;
    }

    private static boolean requiresSort(RelCollation sortCollation, RelCollation inputCollation) {
        if (sortCollation.getFieldCollations().isEmpty()) {
            return false;
        }
        List<RelFieldCollation> sortFields = sortCollation.getFieldCollations();
        List<RelFieldCollation> inputFields = inputCollation.getFieldCollations();
        if (sortFields.size() <= inputFields.size()) {
            for (int i = 0; i < sortFields.size(); ++i) {
                RelFieldCollation inputField;
                RelFieldCollation sortField = sortFields.get(i);
                if (sortField.equals(inputField = inputFields.get(i))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static SortPhysicalRel createSort(SortLogicalRel logicalSort, RelNode physicalInput, boolean requiresSort) {
        RelTraitSet traitSet = OptUtils.traitPlus(physicalInput.getTraitSet(), logicalSort.getCollation());
        return new SortPhysicalRel(logicalSort.getCluster(), traitSet, physicalInput, logicalSort.getCollation(), logicalSort.offset, logicalSort.fetch, logicalSort.getRowType(), requiresSort);
    }
}

