/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.JoinLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ImmutableJoinPhysicalRule;
import com.hazelcast.jet.sql.impl.opt.physical.JoinHashPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.JoinNestedLoopPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import org.immutables.value.Value;

@Value.Enclosing
public final class JoinPhysicalRule
extends RelRule<RelRule.Config> {
    static final RelOptRule INSTANCE = new JoinPhysicalRule(Config.DEFAULT);

    private JoinPhysicalRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        HazelcastTable rightHzTable;
        JoinLogicalRel logicalJoin = (JoinLogicalRel)call.rel(0);
        JoinRelType joinType = logicalJoin.getJoinType();
        if (OptUtils.isBounded(logicalJoin) && joinType != JoinRelType.INNER && joinType != JoinRelType.LEFT) {
            throw new RuntimeException("Unexpected joinType: " + (Object)((Object)joinType));
        }
        Object leftInput = call.rel(1);
        Object rightInput = call.rel(2);
        if (OptUtils.isUnbounded(rightInput)) {
            return;
        }
        RelNode leftInputConverted = RelRule.convert(leftInput, leftInput.getTraitSet().replace(Conventions.PHYSICAL));
        RelNode rightInputConverted = RelRule.convert(rightInput, rightInput.getTraitSet().replace(Conventions.PHYSICAL));
        if (OptUtils.isBounded(leftInput)) {
            JoinHashPhysicalRel rel = new JoinHashPhysicalRel(logicalJoin.getCluster(), logicalJoin.getTraitSet().replace(Conventions.PHYSICAL), leftInputConverted, rightInputConverted, logicalJoin.getCondition(), logicalJoin.getJoinType());
            call.transformTo(rel);
        }
        if (rightInput instanceof TableScan && SqlConnectorUtil.getJetSqlConnector((rightHzTable = rightInput.getTable().unwrap(HazelcastTable.class)).getTarget()).isNestedLoopReaderSupported()) {
            JoinNestedLoopPhysicalRel rel2 = new JoinNestedLoopPhysicalRel(logicalJoin.getCluster(), OptUtils.toPhysicalConvention(logicalJoin.getTraitSet()), leftInputConverted, rightInputConverted, logicalJoin.getCondition(), logicalJoin.getJoinType());
            call.transformTo(rel2);
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinPhysicalRule.Config.builder().description(JoinPhysicalRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(JoinLogicalRel.class).trait(Conventions.LOGICAL).inputs(b1 -> b1.operand(RelNode.class).anyInputs(), b2 -> b2.operand(RelNode.class).anyInputs())).build();

        @Override
        default public RelOptRule toRule() {
            return new JoinPhysicalRule(this);
        }
    }
}

