/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.CalcLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.CalcPhysicalRel;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.convert.ConverterRule;

final class CalcPhysicalRule
extends ConverterRule {
    private static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(CalcLogicalRel.class, Conventions.LOGICAL, Conventions.PHYSICAL, CalcPhysicalRule.class.getSimpleName());
    static final RelOptRule INSTANCE = new CalcPhysicalRule();

    private CalcPhysicalRule() {
        super(DEFAULT_CONFIG);
    }

    @Override
    public RelNode convert(RelNode rel) {
        CalcLogicalRel calc = (CalcLogicalRel)rel;
        RelNode transformedInput = RelOptRule.convert(calc.getInput(), calc.getInput().getTraitSet().replace(Conventions.PHYSICAL));
        return new CalcPhysicalRel(calc.getCluster(), OptUtils.toPhysicalConvention(transformedInput.getTraitSet()), OptUtils.toPhysicalInput(transformedInput), calc.getProgram());
    }
}

