/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.AggregateLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateAbstractPhysicalRule;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateAccumulateByKeyPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateAccumulatePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateByKeyPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateCombineByKeyPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateCombinePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregatePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ImmutableAggregateBatchPhysicalRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.Collection;
import org.immutables.value.Value;

@Value.Enclosing
final class AggregateBatchPhysicalRule
extends AggregateAbstractPhysicalRule {
    static final RelOptRule INSTANCE = new AggregateBatchPhysicalRule(Config.DEFAULT);

    private AggregateBatchPhysicalRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        AggregateLogicalRel logicalAggregate = (AggregateLogicalRel)call.rel(0);
        RelNode input = logicalAggregate.getInput();
        assert (logicalAggregate.getGroupType() == Aggregate.Group.SIMPLE);
        RelNode convertedInput = OptUtils.toPhysicalInput(input);
        Collection<RelNode> transformedInputs = OptUtils.extractPhysicalRelsFromSubset(convertedInput);
        for (RelNode transformedInput : transformedInputs) {
            call.transformTo(this.transform(logicalAggregate, transformedInput));
        }
    }

    private RelNode transform(AggregateLogicalRel logicalAggregate, RelNode physicalInput) {
        return logicalAggregate.getGroupSet().cardinality() == 0 ? AggregateBatchPhysicalRule.toAggregate(logicalAggregate, physicalInput) : AggregateBatchPhysicalRule.toAggregateByKey(logicalAggregate, physicalInput);
    }

    private static RelNode toAggregate(AggregateLogicalRel logicalAggregate, RelNode physicalInput) {
        AggregateOperation<?, JetSqlRow> aggrOp = AggregateBatchPhysicalRule.aggregateOperation(physicalInput.getRowType(), logicalAggregate.getGroupSet(), logicalAggregate.getAggCallList());
        if (logicalAggregate.containsDistinctCall() || logicalAggregate.hasCollation()) {
            return new AggregatePhysicalRel(physicalInput.getCluster(), physicalInput.getTraitSet(), physicalInput, logicalAggregate.getGroupSet(), logicalAggregate.getGroupSets(), logicalAggregate.getAggCallList(), aggrOp);
        }
        AggregateAccumulatePhysicalRel rel = new AggregateAccumulatePhysicalRel(physicalInput.getCluster(), physicalInput.getTraitSet(), physicalInput, aggrOp);
        return new AggregateCombinePhysicalRel(rel.getCluster(), rel.getTraitSet(), (RelNode)rel, logicalAggregate.getGroupSet(), logicalAggregate.getGroupSets(), logicalAggregate.getAggCallList(), aggrOp);
    }

    private static RelNode toAggregateByKey(AggregateLogicalRel logicalAggregate, RelNode physicalInput) {
        AggregateOperation<?, JetSqlRow> aggrOp = AggregateBatchPhysicalRule.aggregateOperation(physicalInput.getRowType(), logicalAggregate.getGroupSet(), logicalAggregate.getAggCallList());
        if (logicalAggregate.containsDistinctCall() || logicalAggregate.hasCollation()) {
            return new AggregateByKeyPhysicalRel(physicalInput.getCluster(), physicalInput.getTraitSet(), physicalInput, logicalAggregate.getGroupSet(), logicalAggregate.getGroupSets(), logicalAggregate.getAggCallList(), aggrOp);
        }
        AggregateAccumulateByKeyPhysicalRel rel = new AggregateAccumulateByKeyPhysicalRel(physicalInput.getCluster(), physicalInput.getTraitSet(), physicalInput, logicalAggregate.getGroupSet(), aggrOp);
        return new AggregateCombineByKeyPhysicalRel(rel.getCluster(), rel.getTraitSet(), (RelNode)rel, logicalAggregate.getGroupSet(), logicalAggregate.getGroupSets(), logicalAggregate.getAggCallList(), aggrOp);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableAggregateBatchPhysicalRule.Config.builder().description(AggregateBatchPhysicalRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(AggregateLogicalRel.class).trait(Conventions.LOGICAL).predicate(OptUtils::isBounded).inputs(b1 -> b1.operand(RelNode.class).anyInputs())).build();

        @Override
        default public RelOptRule toRule() {
            return new AggregateBatchPhysicalRule(this);
        }
    }
}

