/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.org.apache.calcite.plan.RelOptPredicateList;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Calc;
import com.hazelcast.org.apache.calcite.rel.rules.ReduceExpressionsRule;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexLocalRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import java.util.ArrayList;
import java.util.List;

public final class CalcReduceExprRule
extends ReduceExpressionsRule<ReduceExpressionsRule.CalcReduceExpressionsRule.CalcReduceExpressionsRuleConfig> {
    public static final CalcReduceExprRule INSTANCE = new CalcReduceExprRule();

    private CalcReduceExprRule() {
        super(ReduceExpressionsRule.CalcReduceExpressionsRule.CalcReduceExpressionsRuleConfig.DEFAULT);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Calc calc = (Calc)call.rel(0);
        RexProgram program = calc.getProgram();
        List<RexNode> exprList = program.getExprList();
        final ArrayList<RexNode> expandedExprList = new ArrayList<RexNode>();
        RexShuttle shuttle = new RexShuttle(){

            @Override
            public RexNode visitLocalRef(RexLocalRef localRef) {
                return (RexNode)expandedExprList.get(localRef.getIndex());
            }
        };
        for (RexNode expr : exprList) {
            expandedExprList.add(expr.accept(shuttle));
        }
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        if (CalcReduceExprRule.reduceExpressions(calc, expandedExprList, predicates, false, ((ReduceExpressionsRule.CalcReduceExpressionsRule.CalcReduceExpressionsRuleConfig)this.config).matchNullability(), ((ReduceExpressionsRule.CalcReduceExpressionsRule.CalcReduceExpressionsRuleConfig)this.config).treatDynamicCallsAsConstant())) {
            int conditionIndex;
            Object newConditionExp;
            RexProgramBuilder builder = new RexProgramBuilder(calc.getInput().getRowType(), calc.getCluster().getRexBuilder());
            ArrayList<RexLocalRef> list = new ArrayList<RexLocalRef>();
            for (RexNode expr : expandedExprList) {
                list.add(builder.registerInput(expr));
            }
            if (program.getCondition() != null && !((RexNode)(newConditionExp = (RexNode)expandedExprList.get(conditionIndex = program.getCondition().getIndex()))).isAlwaysTrue()) {
                if (newConditionExp instanceof RexLiteral || RexUtil.isNullLiteral((RexNode)newConditionExp, true)) {
                    call.transformTo(this.createEmptyRelOrEquivalent(call, calc));
                    return;
                }
                builder.addCondition((RexNode)list.get(conditionIndex));
            }
            int k = 0;
            for (RexLocalRef projectExpr : program.getProjectList()) {
                int index = projectExpr.getIndex();
                builder.addProject(((RexLocalRef)list.get(index)).getIndex(), program.getOutputRowType().getFieldNames().get(k++));
            }
            Calc newCalc = calc.copy(calc.getTraitSet(), calc.getInput(), builder.getProgram());
            if (newCalc.deepEquals(calc)) {
                return;
            }
            call.transformTo(newCalc);
            call.getPlanner().prune(calc);
        }
    }

    protected RelNode createEmptyRelOrEquivalent(RelOptRuleCall call, Calc input) {
        return call.builder().push(input).empty().build();
    }
}

