/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.logical.ImmutableCalcMergeRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.core.Calc;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@Value.Enclosing
public final class CalcMergeRule
extends RelRule<RelRule.Config> {
    public static final RelOptRule INSTANCE = new CalcMergeRule(Config.DEFAULT);

    private CalcMergeRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Calc upperCalc = (Calc)call.rel(0);
        Calc lowerCalc = (Calc)call.rel(1);
        RexProgram upperCalcProgram = upperCalc.getProgram();
        RexProgram lowerCalcProgram = lowerCalc.getProgram();
        List upperCalcInputIndices = upperCalcProgram.getProjectList().stream().map(upperCalcProgram::expandLocalRef).map(RelOptUtil.InputFinder::bits).collect(Collectors.toList());
        ImmutableBitSet upperFilterIndices = upperCalcProgram.getCondition() != null ? RelOptUtil.InputFinder.bits(upperCalcProgram.expandLocalRef(upperCalcProgram.getCondition())) : ImmutableBitSet.of();
        upperCalcInputIndices.add(upperFilterIndices);
        List lowerCalcProjects = lowerCalcProgram.getProjectList().stream().map(lowerCalcProgram::expandLocalRef).collect(Collectors.toList());
        boolean isMergeable = true;
        for (int i = 0; i < lowerCalcProjects.size(); ++i) {
            RexNode project = (RexNode)lowerCalcProjects.get(i);
            int nonDeterministicRexRefCount = 0;
            if (!RexUtil.isDeterministic(project)) {
                for (ImmutableBitSet bitSet : upperCalcInputIndices) {
                    for (Integer ref : bitSet) {
                        if (ref != i) continue;
                        ++nonDeterministicRexRefCount;
                    }
                }
            }
            isMergeable &= nonDeterministicRexRefCount <= 1;
        }
        return isMergeable;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Calc upperCalc = (Calc)call.rel(0);
        Calc lowerCalc = (Calc)call.rel(1);
        RexProgram topProgram = upperCalc.getProgram();
        RexBuilder rexBuilder = upperCalc.getCluster().getRexBuilder();
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(upperCalc.getProgram(), lowerCalc.getProgram(), rexBuilder);
        assert (mergedProgram.getOutputRowType().equals(topProgram.getOutputRowType()));
        Calc newCalc = upperCalc.copy(upperCalc.getTraitSet(), lowerCalc.getInput(), mergedProgram);
        if (newCalc.getDigest().equals(lowerCalc.getDigest())) {
            call.getPlanner().prune(upperCalc);
        }
        call.transformTo(newCalc);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableCalcMergeRule.Config.builder().description(CalcMergeRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(Calc.class).inputs(b1 -> b1.operand(Calc.class).anyInputs())).build();

        @Override
        default public RelOptRule toRule() {
            return new CalcMergeRule(this);
        }
    }
}

