/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.common;

import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.FullScan;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.common.ImmutableCalcIntoScanRule;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastRelOptTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.org.apache.calcite.plan.RelOptPredicateList;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelRule;
import com.hazelcast.org.apache.calcite.rel.core.Calc;
import com.hazelcast.org.apache.calcite.rel.core.Project;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.rex.RexSimplify;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.util.Permutation;
import java.util.Arrays;
import java.util.List;
import org.immutables.value.Value;

@Value.Enclosing
public final class CalcIntoScanRule
extends RelRule<RelRule.Config>
implements TransformationRule {
    public static final CalcIntoScanRule INSTANCE = new CalcIntoScanRule(Config.DEFAULT);

    private CalcIntoScanRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FullScan scan = (FullScan)call.rel(1);
        HazelcastTable table = OptUtils.extractHazelcastTable(scan);
        Permutation permutation = Project.getPermutation(table.getTarget().getFieldCount(), table.getProjects());
        return permutation != null && permutation.isIdentity();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Calc calc = (Calc)call.rel(0);
        FullScan scan = (FullScan)call.rel(1);
        HazelcastTable table = OptUtils.extractHazelcastTable(scan);
        RexProgram program = calc.getProgram();
        assert (scan.getConvention() == Conventions.LOGICAL);
        List<RexNode> newProjects = program.expandList(program.getProjectList());
        HazelcastTable newTable = table.withProject(newProjects, program.getOutputRowType());
        if (program.getCondition() != null) {
            RexNode calcFilter = program.expandLocalRef(program.getCondition());
            RexNode scanFilter = table.getFilter();
            RexSimplify rexSimplify = new RexSimplify(call.builder().getRexBuilder(), RelOptPredicateList.EMPTY, RexUtil.EXECUTOR);
            RexNode simplifiedCondition = rexSimplify.simplifyFilterPredicates(Arrays.asList(calcFilter, scanFilter));
            newTable = newTable.withFilter(simplifiedCondition);
        }
        HazelcastRelOptTable convertedTable = OptUtils.createRelTable((HazelcastRelOptTable)scan.getTable(), newTable, scan.getCluster().getTypeFactory());
        call.transformTo(new FullScanLogicalRel(scan.getCluster(), OptUtils.toLogicalConvention(scan.getTraitSet()), convertedTable, scan.eventTimePolicyProvider(), OptUtils.getTargetField(program, scan.watermarkedColumnIndex())));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableCalcIntoScanRule.Config.builder().description(CalcIntoScanRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(Calc.class).trait(Conventions.LOGICAL).inputs(b1 -> b1.operand(FullScan.class).anyInputs())).build();

        @Override
        default public RelOptRule toRule() {
            return new CalcIntoScanRule(this);
        }
    }
}

