/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.internal.util.MutableByte;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.SlidingWindow;
import com.hazelcast.jet.sql.impl.opt.metadata.WatermarkedFields;
import com.hazelcast.jet.sql.impl.opt.physical.CalcPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.DropLateItemsPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SlidingWindowAggregatePhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.StreamToStreamJoinPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.UnionPhysicalRel;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelVisitor;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.sql.impl.QueryException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WatermarkKeysAssigner {
    private final PhysicalRel root;
    private final KeyAssignerVisitor visitor;
    private byte keyCounter;

    public WatermarkKeysAssigner(PhysicalRel root) {
        this.root = root;
        this.visitor = new KeyAssignerVisitor();
    }

    public void assignWatermarkKeys() {
        this.visitor.go(this.root);
    }

    public Map<Integer, MutableByte> getWatermarkedFieldsKey(RelNode node) {
        return this.visitor.getRelToWmKeyMapping().get(node);
    }

    static /* synthetic */ byte access$008(WatermarkKeysAssigner x0) {
        byte by = x0.keyCounter;
        x0.keyCounter = (byte)(by + 1);
        return by;
    }

    private class KeyAssignerVisitor
    extends RelVisitor {
        private final Map<RelNode, Map<Integer, MutableByte>> relToWmKeyMapping = new HashMap<RelNode, Map<Integer, MutableByte>>();

        KeyAssignerVisitor() {
        }

        public Map<RelNode, Map<Integer, MutableByte>> getRelToWmKeyMapping() {
            return this.relToWmKeyMapping;
        }

        @Override
        public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
            this.visit0(node, ordinal, parent);
            WatermarkedFields wmFields = OptUtils.metadataQuery(node).extractWatermarkedFields(node);
            if (!Objects.equals(wmFields == null ? Collections.emptySet() : wmFields.getFieldIndexes(), this.relToWmKeyMapping.getOrDefault(node, Collections.emptyMap()).keySet())) {
                throw new RuntimeException("mismatch between WM fields in metadata query and in WmKeyAssigner");
            }
        }

        private void visit0(RelNode node, int ordinal, @Nullable RelNode parent) {
            super.visit(node, ordinal, parent);
            if (node instanceof FullScanPhysicalRel) {
                assert (node.getInputs().isEmpty()) : "FullScan not a leaf";
                FullScanPhysicalRel scan = (FullScanPhysicalRel)node;
                if (scan.watermarkedColumnIndex() < 0) {
                    return;
                }
                MutableByte key = new MutableByte(WatermarkKeysAssigner.this.keyCounter);
                Map<Integer, MutableByte> res = Collections.singletonMap(scan.watermarkedColumnIndex(), key);
                Map<Integer, MutableByte> oldValue = this.relToWmKeyMapping.put(scan, res);
                assert (oldValue == null) : "The same scan used twice in the execution plan";
                WatermarkKeysAssigner.access$008(WatermarkKeysAssigner.this);
                return;
            }
            if (this.relToWmKeyMapping.isEmpty()) {
                return;
            }
            if (node instanceof CalcPhysicalRel) {
                CalcPhysicalRel calc = (CalcPhysicalRel)node;
                List<RexNode> projects = calc.getProgram().expandList(calc.getProgram().getProjectList());
                Map<Integer, MutableByte> refByteMap = this.relToWmKeyMapping.get(calc.getInput());
                if (refByteMap == null) {
                    return;
                }
                HashMap<Integer, MutableByte> calcRefByteMap = new HashMap<Integer, MutableByte>();
                for (int projectIndex = 0; projectIndex < projects.size(); ++projectIndex) {
                    RexInputRef ref;
                    int idx;
                    MutableByte wmKey;
                    if (!(projects.get(projectIndex) instanceof RexInputRef) || (wmKey = refByteMap.get(idx = (ref = (RexInputRef)projects.get(projectIndex)).getIndex())) == null) continue;
                    calcRefByteMap.put(projectIndex, wmKey);
                }
                this.relToWmKeyMapping.put(calc, calcRefByteMap);
            } else if (node instanceof UnionPhysicalRel) {
                UnionPhysicalRel union = (UnionPhysicalRel)node;
                assert (!union.getInputs().isEmpty());
                HashMap intersection = new HashMap(this.relToWmKeyMapping.getOrDefault(union.getInput(0), Collections.emptyMap()));
                for (int inputIndex = 0; inputIndex < union.getInputs().size(); ++inputIndex) {
                    Map inputWmKeys = this.relToWmKeyMapping.getOrDefault(union.getInput(inputIndex), Collections.emptyMap());
                    Iterator intersectionIt = intersection.entrySet().iterator();
                    while (intersectionIt.hasNext()) {
                        Map.Entry intersectionEntry = intersectionIt.next();
                        MutableByte inputWmKey = (MutableByte)inputWmKeys.get(intersectionEntry.getKey());
                        if (inputWmKey == null) {
                            intersectionIt.remove();
                            continue;
                        }
                        inputWmKey.setValue(((MutableByte)intersectionEntry.getValue()).getValue());
                    }
                }
                this.relToWmKeyMapping.put(union, intersection);
            } else if (node instanceof StreamToStreamJoinPhysicalRel) {
                StreamToStreamJoinPhysicalRel join = (StreamToStreamJoinPhysicalRel)node;
                Map<Integer, MutableByte> leftWmKeyMapping = this.relToWmKeyMapping.get(join.getLeft());
                if (leftWmKeyMapping == null) {
                    throw QueryException.error((String)"Left input of stream-to-stream JOIN doesn't contain watermarks");
                }
                Map<Integer, MutableByte> rightWmKeyMapping = this.relToWmKeyMapping.get(join.getRight());
                if (rightWmKeyMapping == null) {
                    throw QueryException.error((String)"Right input of stream-to-stream JOIN doesn't contain watermarks");
                }
                HashMap<Integer, MutableByte> joinedRefByteMap = new HashMap<Integer, MutableByte>();
                int leftFieldCount = join.getLeft().getRowType().getFieldCount();
                for (Map.Entry<Integer, MutableByte> en : leftWmKeyMapping.entrySet()) {
                    joinedRefByteMap.put(en.getKey(), en.getValue());
                }
                for (Map.Entry<Integer, MutableByte> en : rightWmKeyMapping.entrySet()) {
                    joinedRefByteMap.put(en.getKey() + leftFieldCount, en.getValue());
                }
                assert (leftWmKeyMapping.size() + rightWmKeyMapping.size() == joinedRefByteMap.size());
                this.relToWmKeyMapping.put(join, joinedRefByteMap);
            } else if (node instanceof Join) {
                Join join = (Join)node;
                Map<Integer, MutableByte> refByteMap = this.relToWmKeyMapping.get(join.getLeft());
                this.relToWmKeyMapping.put(node, refByteMap);
            } else if (node instanceof SlidingWindowAggregatePhysicalRel) {
                SlidingWindowAggregatePhysicalRel swAgg = (SlidingWindowAggregatePhysicalRel)node;
                Map<Integer, MutableByte> inputWmKeys = this.relToWmKeyMapping.get(swAgg.getInput());
                if (inputWmKeys == null) {
                    return;
                }
                MutableByte inputTimestampKey = inputWmKeys.get(swAgg.timestampFieldIndex());
                if (inputTimestampKey == null) {
                    return;
                }
                WatermarkedFields watermarkedFields = swAgg.watermarkedFields();
                HashMap<Integer, MutableByte> refByteMap = new HashMap<Integer, MutableByte>();
                for (Integer fieldIndex : watermarkedFields.getFieldIndexes()) {
                    refByteMap.put(fieldIndex, inputTimestampKey);
                }
                this.relToWmKeyMapping.put(swAgg, refByteMap);
            } else if (node instanceof SlidingWindow) {
                SlidingWindow sw = (SlidingWindow)node;
                this.relToWmKeyMapping.put(sw, this.relToWmKeyMapping.get(sw.getInput()));
            } else if (node instanceof Aggregate) {
                Aggregate agg = (Aggregate)node;
                WatermarkedFields inputWmFields = OptUtils.metadataQuery(agg).extractWatermarkedFields(agg.getInput());
                if (inputWmFields == null || agg.getGroupSets().size() != 1) {
                    return;
                }
                Map<Integer, MutableByte> inputByteMap = this.relToWmKeyMapping.get(agg.getInput());
                HashMap<Integer, MutableByte> byteMap = new HashMap<Integer, MutableByte>();
                Iterator<Integer> groupedIndexes = ((ImmutableBitSet)agg.getGroupSets().get(0)).iterator();
                int outputIndex = 0;
                while (groupedIndexes.hasNext()) {
                    int groupedBy = groupedIndexes.next();
                    if (inputWmFields.getFieldIndexes().contains(groupedBy)) {
                        byteMap.put(groupedBy, inputByteMap.get(outputIndex));
                    }
                    ++outputIndex;
                }
                this.relToWmKeyMapping.put(agg, byteMap);
            } else if (node instanceof DropLateItemsPhysicalRel) {
                this.relToWmKeyMapping.put(node, this.relToWmKeyMapping.get(node.getInput(0)));
            } else {
                return;
            }
        }
    }
}

