/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelWriter;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.util.Collections;
import javax.annotation.Nullable;

public abstract class FullScan
extends TableScan {
    protected final BiFunctionEx<ExpressionEvalContext, Byte, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider;
    protected final int watermarkedColumnIndex;

    protected FullScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, @Nullable BiFunctionEx<ExpressionEvalContext, Byte, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider, int watermarkedColumnIndex) {
        super(cluster, traitSet, Collections.emptyList(), table);
        assert (watermarkedColumnIndex < 0 ^ eventTimePolicyProvider != null);
        this.eventTimePolicyProvider = eventTimePolicyProvider;
        this.watermarkedColumnIndex = watermarkedColumnIndex;
    }

    @Nullable
    public BiFunctionEx<ExpressionEvalContext, Byte, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider() {
        return this.eventTimePolicyProvider;
    }

    public int watermarkedColumnIndex() {
        return this.watermarkedColumnIndex;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String eventPolicyPresence = this.eventTimePolicyProvider != null ? "Present" : "Absent";
        return super.explainTerms(pw).itemIf("eventTimePolicyProvider", eventPolicyPresence, this.eventTimePolicyProvider != null).itemIf("watermarkedColumnIndex", this.watermarkedColumnIndex, this.watermarkedColumnIndex >= 0);
    }
}

