/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.jet.sql.impl.inject.CompactUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CompactUpsertTargetDescriptor
implements UpsertTargetDescriptor {
    private Schema schema;

    private CompactUpsertTargetDescriptor() {
    }

    public CompactUpsertTargetDescriptor(@Nonnull Schema schema) {
        this.schema = schema;
    }

    @Override
    public UpsertTarget create(InternalSerializationService serializationService) {
        return new CompactUpsertTarget(this.schema);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.schema);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.schema = (Schema)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactUpsertTargetDescriptor that = (CompactUpsertTargetDescriptor)o;
        return Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.schema);
    }

    public String toString() {
        return "CompactUpsertTargetDescriptor{+ schema=" + this.schema + '}';
    }
}

