/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.com.google.gson.Gson;
import com.hazelcast.com.google.gson.GsonBuilder;
import com.hazelcast.com.google.gson.JsonPrimitive;
import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.Converters;

public final class JsonCreationUtil {
    private static final Gson SERIALIZER = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();

    private JsonCreationUtil() {
    }

    public static String serializeValue(Object value) {
        Object result;
        if (value == null) {
            return "null";
        }
        if (value instanceof HazelcastJsonValue) {
            return value.toString();
        }
        Converter converter = Converters.getConverter(value.getClass());
        switch (converter.getTypeFamily()) {
            case TIME: 
            case DATE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIME_ZONE: {
                result = converter.asVarchar(value);
                break;
            }
            default: {
                result = value;
            }
        }
        return SERIALIZER.toJson(result);
    }

    public static String serializeString(String string) {
        if (string == null) {
            return "null";
        }
        return SERIALIZER.toJson(new JsonPrimitive(string));
    }
}

