/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.SchemaWriter;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.inject.CompactUpsertTargetDescriptor;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

final class MetadataCompactResolver
implements KvMetadataResolver {
    static final MetadataCompactResolver INSTANCE = new MetadataCompactResolver();

    private MetadataCompactResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.of("compact");
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        if (userFields.isEmpty()) {
            throw QueryException.error((String)"Column list is required for Compact format");
        }
        String typeNameProperty = isKey ? "keyCompactTypeName" : "valueCompactTypeName";
        String typeName = options.get(typeNameProperty);
        if (typeName == null) {
            throw QueryException.error((String)("Unable to resolve table metadata. Missing '" + typeNameProperty + "' option"));
        }
        Map<QueryPath, MappingField> fields = KvMetadataResolver.extractFields(userFields, isKey);
        return fields.entrySet().stream().map(entry -> {
            QueryPath path = (QueryPath)entry.getKey();
            if (path.getPath() == null) {
                throw QueryException.error((String)("Cannot use the '" + path + "' field with Compact serialization"));
            }
            QueryDataType type = ((MappingField)entry.getValue()).type();
            if (type == QueryDataType.OBJECT) {
                throw QueryException.error((String)("Cannot derive Compact type for '" + type.getTypeFamily() + "'"));
            }
            return (MappingField)entry.getValue();
        });
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(resolvedFields, isKey);
        String typeNameProperty = isKey ? "keyCompactTypeName" : "valueCompactTypeName";
        String typeName = options.get(typeNameProperty);
        ArrayList<TableField> fields = new ArrayList<TableField>(fieldsByPath.size());
        for (Map.Entry<QueryPath, MappingField> entry : fieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add((TableField)new MapTableField(name, type, false, path));
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, QueryDataType.OBJECT);
        Schema schema = this.resolveSchema(typeName, fieldsByPath);
        return new KvMetadata(fields, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, new CompactUpsertTargetDescriptor(schema));
    }

    private Schema resolveSchema(String typeName, Map<QueryPath, MappingField> fields) {
        SchemaWriter schemaWriter = new SchemaWriter(typeName);
        for (Map.Entry<QueryPath, MappingField> entry : fields.entrySet()) {
            String name = entry.getKey().getPath();
            QueryDataType type = entry.getValue().type();
            schemaWriter.addField(new FieldDescriptor(name, MetadataCompactResolver.resolveToCompactKind(type.getTypeFamily())));
        }
        return schemaWriter.build();
    }

    private static FieldKind resolveToCompactKind(QueryDataTypeFamily type) {
        switch (type) {
            case BOOLEAN: {
                return FieldKind.NULLABLE_BOOLEAN;
            }
            case TINYINT: {
                return FieldKind.NULLABLE_INT8;
            }
            case SMALLINT: {
                return FieldKind.NULLABLE_INT16;
            }
            case INTEGER: {
                return FieldKind.NULLABLE_INT32;
            }
            case BIGINT: {
                return FieldKind.NULLABLE_INT64;
            }
            case REAL: {
                return FieldKind.NULLABLE_FLOAT32;
            }
            case DOUBLE: {
                return FieldKind.NULLABLE_FLOAT64;
            }
            case DECIMAL: {
                return FieldKind.DECIMAL;
            }
            case VARCHAR: {
                return FieldKind.STRING;
            }
            case TIME: {
                return FieldKind.TIME;
            }
            case DATE: {
                return FieldKind.DATE;
            }
            case TIMESTAMP: {
                return FieldKind.TIMESTAMP;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return FieldKind.TIMESTAMP_WITH_TIMEZONE;
            }
            case OBJECT: {
                return FieldKind.COMPACT;
            }
        }
        throw new IllegalArgumentException("Compact format does not allow " + type + " data type");
    }
}

