/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.processor.TransformP;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.QueryUtil;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
final class JoinByEquiJoinProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private JetJoinInfo joinInfo;
    private String mapName;
    private int partitionCount;
    private int[] partitions;
    private KvRowProjector.Supplier rightRowProjectorSupplier;
    private transient MapProxyImpl<Object, Object> map;
    private transient ExpressionEvalContext evalContext;
    private transient Extractors extractors;

    private JoinByEquiJoinProcessorSupplier() {
    }

    JoinByEquiJoinProcessorSupplier(@Nonnull JetJoinInfo joinInfo, @Nonnull String mapName, int partitionCount, @Nullable int[] partitions, @Nonnull KvRowProjector.Supplier rightRowProjectorSupplier) {
        assert (joinInfo.isEquiJoin() && (joinInfo.isInner() || joinInfo.isLeftOuter()));
        this.joinInfo = joinInfo;
        this.mapName = mapName;
        this.partitionCount = partitionCount;
        this.partitions = partitions;
        this.rightRowProjectorSupplier = rightRowProjectorSupplier;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.map = (MapProxyImpl)context.hazelcastInstance().getMap(this.mapName);
        this.evalContext = ExpressionEvalContext.from((ProcessorSupplier.Context)context);
        this.extractors = Extractors.newBuilder((InternalSerializationService)this.evalContext.getSerializationService()).build();
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<1> processors = new ArrayList<1>(count);
        for (int i = 0; i < count; ++i) {
            PartitionIdSet partitions = this.partitions == null ? null : new PartitionIdSet(this.partitionCount, this.partitions);
            QueryPath[] rightPaths = this.rightRowProjectorSupplier.paths();
            KvRowProjector rightProjector = this.rightRowProjectorSupplier.get(this.evalContext, this.extractors);
            TransformP<JetSqlRow, JetSqlRow> processor = new TransformP<JetSqlRow, JetSqlRow>(JoinByEquiJoinProcessorSupplier.joinFn(this.joinInfo, this.map, partitions, rightPaths, rightProjector, this.evalContext)){

                public boolean isCooperative() {
                    return false;
                }
            };
            processors.add(processor);
        }
        return processors;
    }

    private static FunctionEx<JetSqlRow, Traverser<JetSqlRow>> joinFn(JetJoinInfo joinInfo, MapProxyImpl<Object, Object> map, PartitionIdSet partitions, QueryPath[] rightPaths, KvRowProjector rightRowProjector, ExpressionEvalContext evalContext) {
        return (FunctionEx & Serializable)left -> {
            Predicate<Object, Object> predicate = QueryUtil.toPredicate(left, joinInfo.leftEquiJoinIndices(), joinInfo.rightEquiJoinIndices(), rightPaths);
            if (predicate == null) {
                return joinInfo.isInner() ? Traversers.empty() : Traversers.singleton((Object)left.extendedRow(rightRowProjector.getColumnCount()));
            }
            Set matchingRows = joinInfo.isInner() ? map.entrySet(predicate, partitions.copy()) : map.entrySet(predicate);
            List<JetSqlRow> joined = JoinByEquiJoinProcessorSupplier.join(left, matchingRows, rightRowProjector, joinInfo.nonEquiCondition(), evalContext);
            return joined.isEmpty() && joinInfo.isLeftOuter() ? Traversers.singleton((Object)left.extendedRow(rightRowProjector.getColumnCount())) : Traversers.traverseIterable(joined);
        };
    }

    private static List<JetSqlRow> join(JetSqlRow left, Set<Map.Entry<Object, Object>> entries, KvRowProjector rightRowProjector, Expression<Boolean> condition, ExpressionEvalContext evalContext) {
        ArrayList<JetSqlRow> rows = new ArrayList<JetSqlRow>();
        for (Map.Entry<Object, Object> entry : entries) {
            JetSqlRow joined;
            JetSqlRow right = rightRowProjector.project(entry.getKey(), entry.getValue());
            if (right == null || (joined = ExpressionUtil.join(left, right, condition, evalContext)) == null) continue;
            rows.add(joined);
        }
        return rows;
    }

    public List<Permission> permissions() {
        return Collections.singletonList(new MapPermission(this.mapName, new String[]{"create", "read"}));
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.joinInfo);
        out.writeObject((Object)this.mapName);
        out.writeInt(this.partitionCount);
        out.writeObject((Object)this.partitions);
        out.writeObject((Object)this.rightRowProjectorSupplier);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.joinInfo = (JetJoinInfo)in.readObject();
        this.mapName = (String)in.readObject();
        this.partitionCount = in.readInt();
        this.partitions = (int[])in.readObject();
        this.rightRowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
    }

    static ProcessorMetaSupplier supplier(JetJoinInfo joinInfo, String mapName, KvRowProjector.Supplier rightRowProjectorSupplier) {
        return new Supplier(joinInfo, mapName, rightRowProjectorSupplier);
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
    private static final class Supplier
    implements ProcessorMetaSupplier,
    DataSerializable {
        private JetJoinInfo joinInfo;
        private String mapName;
        private KvRowProjector.Supplier rightRowProjectorSupplier;
        private transient Map<Address, int[]> partitionAssignment;

        private Supplier() {
        }

        private Supplier(JetJoinInfo joinInfo, String mapName, KvRowProjector.Supplier rightRowProjectorSupplier) {
            assert (joinInfo.isEquiJoin() && (joinInfo.isInner() || joinInfo.isLeftOuter()));
            this.joinInfo = joinInfo;
            this.mapName = mapName;
            this.rightRowProjectorSupplier = rightRowProjectorSupplier;
        }

        public void init(@Nonnull ProcessorMetaSupplier.Context context) {
            this.partitionAssignment = context.partitionAssignment();
        }

        @Nonnull
        public Function<? super Address, ? extends ProcessorSupplier> get(@Nonnull List<Address> addresses) {
            if (this.joinInfo.isInner()) {
                int partitionCount = this.partitionAssignment.values().stream().mapToInt(a -> ((int[])a).length).sum();
                return address -> new JoinByEquiJoinProcessorSupplier(this.joinInfo, this.mapName, partitionCount, this.partitionAssignment.get(address), this.rightRowProjectorSupplier);
            }
            return address -> new JoinByEquiJoinProcessorSupplier(this.joinInfo, this.mapName, 0, null, this.rightRowProjectorSupplier);
        }

        public boolean initIsCooperative() {
            return true;
        }

        public boolean closeIsCooperative() {
            return true;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.joinInfo);
            out.writeObject((Object)this.mapName);
            out.writeObject((Object)this.rightRowProjectorSupplier);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.joinInfo = (JetJoinInfo)in.readObject();
            this.mapName = (String)in.readObject();
            this.rightRowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
        }
    }
}

