/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.extract.AvroQueryTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.AvroUpsertTargetDescriptor;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;

public final class KvMetadataAvroResolver
implements KvMetadataResolver {
    public static final KvMetadataAvroResolver INSTANCE = new KvMetadataAvroResolver();

    private KvMetadataAvroResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.of("avro");
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        if (userFields.isEmpty()) {
            throw QueryException.error((String)"Column list is required for Avro format");
        }
        return KvMetadataResolver.extractFields(userFields, isKey).entrySet().stream().map(entry -> {
            QueryPath path = (QueryPath)entry.getKey();
            if (path.getPath() == null) {
                throw QueryException.error((String)("Cannot use the '" + path + "' field with Avro serialization"));
            }
            return (MappingField)entry.getValue();
        });
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(resolvedFields, isKey);
        ArrayList<TableField> fields = new ArrayList<TableField>();
        for (Map.Entry<QueryPath, MappingField> entry : fieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add((TableField)new MapTableField(name, type, false, path));
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, QueryDataType.OBJECT);
        return new KvMetadata(fields, AvroQueryTargetDescriptor.INSTANCE, new AvroUpsertTargetDescriptor(this.schema(fields).toString()));
    }

    private Schema schema(List<TableField> fields) {
        QueryPath[] paths = this.paths(fields);
        QueryDataType[] types = this.types(fields);
        SchemaBuilder.FieldAssembler schema = SchemaBuilder.record((String)"jet.sql").fields();
        block9: for (int i = 0; i < fields.size(); ++i) {
            String path = paths[i].getPath();
            if (path == null) continue;
            QueryDataType type = types[i];
            switch (type.getTypeFamily()) {
                case BOOLEAN: {
                    schema = ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)schema.name(path).type().unionOf().nullType().and().booleanType()).endUnion()).nullDefault();
                    continue block9;
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: {
                    schema = ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)schema.name(path).type().unionOf().nullType().and().intType()).endUnion()).nullDefault();
                    continue block9;
                }
                case BIGINT: {
                    schema = ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)schema.name(path).type().unionOf().nullType().and().longType()).endUnion()).nullDefault();
                    continue block9;
                }
                case REAL: {
                    schema = ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)schema.name(path).type().unionOf().nullType().and().floatType()).endUnion()).nullDefault();
                    continue block9;
                }
                case DOUBLE: {
                    schema = ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)schema.name(path).type().unionOf().nullType().and().doubleType()).endUnion()).nullDefault();
                    continue block9;
                }
                case DECIMAL: 
                case TIME: 
                case DATE: 
                case TIMESTAMP: 
                case TIMESTAMP_WITH_TIME_ZONE: 
                case VARCHAR: {
                    schema = ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)schema.name(path).type().unionOf().nullType().and().stringType()).endUnion()).nullDefault();
                    continue block9;
                }
                case OBJECT: {
                    schema = ((SchemaBuilder.NullDefault)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)schema.name(path).type().unionOf().nullType().and().booleanType()).and().intType()).and().longType()).and().floatType()).and().doubleType()).and().stringType()).endUnion()).nullDefault();
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type: " + type.getTypeFamily());
                }
            }
        }
        return (Schema)schema.endRecord();
    }

    private QueryPath[] paths(List<TableField> fields) {
        return (QueryPath[])fields.stream().map(field -> ((MapTableField)field).getPath()).toArray(QueryPath[]::new);
    }

    private QueryDataType[] types(List<TableField> fields) {
        return (QueryDataType[])fields.stream().map(TableField::getType).toArray(QueryDataType[]::new);
    }
}

