/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.WriteJdbcP;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractJdbcSqlConnectorProcessorSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.org.checkerframework.checker.nullness.qual.NonNull;
import com.hazelcast.security.impl.function.SecuredFunction;
import com.hazelcast.security.permission.ConnectorPermission;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.CommonDataSource;

public class UpdateProcessorSupplier
extends AbstractJdbcSqlConnectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable,
SecuredFunction {
    private String query;
    private int[] parameterPositions;
    private int batchLimit;
    private transient ExpressionEvalContext evalContext;

    public UpdateProcessorSupplier() {
    }

    public UpdateProcessorSupplier(@Nonnull String externalDataStoreRef, @NonNull String query, @Nonnull int[] parameterPositions, int batchLimit) {
        super(externalDataStoreRef);
        this.query = Objects.requireNonNull(query, "query must not be null");
        this.parameterPositions = Objects.requireNonNull(parameterPositions, "parameterPositions must not be null");
        this.batchLimit = batchLimit;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        super.init(context);
        this.evalContext = ExpressionEvalContext.from((ProcessorSupplier.Context)context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<WriteJdbcP> processors = new ArrayList<WriteJdbcP>(count);
        for (int i = 0; i < count; ++i) {
            WriteJdbcP processor = new WriteJdbcP(this.query, (CommonDataSource)this.dataSource, (BiConsumerEx & Serializable)(ps, row) -> {
                int j;
                List arguments = this.evalContext.getArguments();
                for (j = 0; j < this.parameterPositions.length; ++j) {
                    ps.setObject(j + 1, arguments.get(this.parameterPositions[j]));
                }
                for (j = 0; j < row.getFieldCount(); ++j) {
                    ps.setObject(this.parameterPositions.length + j + 1, row.get(j));
                }
            }, false, this.batchLimit);
            processors.add(processor);
        }
        return processors;
    }

    @Nullable
    public List<Permission> permissions() {
        return Collections.singletonList(ConnectorPermission.jdbc((String)this.externalDataStoreRef, (String)"write"));
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.externalDataStoreRef);
        out.writeString(this.query);
        out.writeIntArray(this.parameterPositions);
        out.writeInt(this.batchLimit);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.externalDataStoreRef = in.readString();
        this.query = in.readString();
        this.parameterPositions = in.readIntArray();
        this.batchLimit = in.readInt();
    }
}

