/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTableField;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class JdbcTable
extends JetTable {
    private final List<String> dbFieldNames;
    private final List<String> primaryKeyFieldNames;
    private final SqlDialect sqlDialect;
    private final String externalName;
    private final String externalDataStoreRef;
    private final int batchLimit;
    private final SerializationService serializationService;

    public JdbcTable(@Nonnull SqlConnector sqlConnector, @Nonnull List<TableField> fields, @Nonnull SqlDialect dialect, @Nonnull String schemaName, @Nonnull String name, @Nonnull TableStatistics statistics, @Nonnull String externalName, @Nonnull String externalDataStoreRef, int batchLimit, @Nonnull SerializationService serializationService) {
        super(sqlConnector, fields, schemaName, name, statistics);
        ArrayList<String> dbFieldNames = new ArrayList<String>(fields.size());
        ArrayList<String> primaryKeyFieldNames = new ArrayList<String>(1);
        for (TableField field : fields) {
            JdbcTableField jdbcField = (JdbcTableField)field;
            dbFieldNames.add(jdbcField.externalName());
            if (!jdbcField.isPrimaryKey()) continue;
            primaryKeyFieldNames.add(jdbcField.getName());
        }
        this.dbFieldNames = Collections.unmodifiableList(dbFieldNames);
        this.primaryKeyFieldNames = Collections.unmodifiableList(primaryKeyFieldNames);
        this.sqlDialect = dialect;
        this.externalName = externalName;
        this.externalDataStoreRef = externalDataStoreRef;
        this.batchLimit = batchLimit;
        this.serializationService = serializationService;
    }

    public List<String> dbFieldNames() {
        return this.dbFieldNames;
    }

    public SqlDialect sqlDialect() {
        return this.sqlDialect;
    }

    public String getExternalName() {
        return this.externalName;
    }

    public String getExternalDataStoreRef() {
        return this.externalDataStoreRef;
    }

    public int getBatchLimit() {
        return this.batchLimit;
    }

    public JdbcTableField getField(String fieldName) {
        List fields = this.getFields();
        for (TableField field : fields) {
            if (!field.getName().equals(fieldName)) continue;
            return (JdbcTableField)field;
        }
        throw new IllegalArgumentException("Unknown field with name " + fieldName);
    }

    public JdbcTableField getFieldByExternalName(String externalName) {
        List fields = this.getFields();
        for (TableField field0 : fields) {
            JdbcTableField field = (JdbcTableField)field0;
            if (!field.externalName().equals(externalName)) continue;
            return field;
        }
        throw new IllegalArgumentException("Unknown field with name " + externalName);
    }

    public List<String> getPrimaryKeyList() {
        return this.primaryKeyFieldNames;
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public PlanObjectKey getObjectKey() {
        return new JdbcPlanObjectKey();
    }

    static final class JdbcPlanObjectKey
    implements PlanObjectKey {
        JdbcPlanObjectKey() {
        }
    }
}

