/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.datastore.ExternalDataStoreFactory;
import com.hazelcast.datastore.impl.CloseableDataSource;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.DeleteProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.DeleteQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.InsertProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.InsertQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTableField;
import com.hazelcast.jet.sql.impl.connector.jdbc.SelectProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.SelectQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.UpdateProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.UpdateQueryBuilder;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;

public class JdbcSqlConnector
implements SqlConnector {
    public static final String TYPE_NAME = "JDBC";
    public static final String OPTION_EXTERNAL_DATASTORE_REF = "externalDataStoreRef";
    public static final String OPTION_JDBC_BATCH_LIMIT = "jdbc.batch-limit";
    public static final String JDBC_BATCH_LIMIT_DEFAULT_VALUE = "100";
    private static final ILogger LOG = Logger.getLogger(JdbcSqlConnector.class);

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isStream() {
        return false;
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull Map<String, String> options, @Nonnull List<MappingField> userFields, @Nonnull String externalName) {
        Map<String, DbField> dbFields = this.readDbFields(nodeEngine, options, externalName);
        ArrayList<MappingField> resolvedFields = new ArrayList<MappingField>();
        if (userFields.isEmpty()) {
            for (DbField dbField : dbFields.values()) {
                try {
                    MappingField mappingField = new MappingField(dbField.columnName, this.resolveType(dbField.columnTypeName));
                    mappingField.setPrimaryKey(dbField.primaryKey);
                    resolvedFields.add(mappingField);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Could not load column class " + dbField.columnTypeName, e);
                }
            }
        } else {
            for (MappingField f : userFields) {
                MappingField mappingField;
                DbField dbField;
                if (f.externalName() != null) {
                    dbField = dbFields.get(f.externalName());
                    if (dbField == null) {
                        throw new IllegalStateException("could not resolve field with external name " + f.externalName());
                    }
                    this.validateType(f, dbField);
                    mappingField = new MappingField(f.name(), f.type(), f.externalName());
                    mappingField.setPrimaryKey(dbField.primaryKey);
                    resolvedFields.add(mappingField);
                    continue;
                }
                dbField = dbFields.get(f.name());
                if (dbField == null) {
                    throw new IllegalStateException("could not resolve field with name " + f.name());
                }
                this.validateType(f, dbField);
                mappingField = new MappingField(f.name(), f.type());
                mappingField.setPrimaryKey(dbField.primaryKey);
                resolvedFields.add(mappingField);
            }
        }
        return resolvedFields;
    }

    /*
     * Exception decompiling
     */
    private Map<String, DbField> readDbFields(NodeEngine nodeEngine, Map<String, String> options, String externalTableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void closeDataSource(DataSource dataSource) {
        if (dataSource instanceof CloseableDataSource) {
            try {
                ((CloseableDataSource)dataSource).close();
            }
            catch (Exception e) {
                throw new HazelcastException("Could not close datasource " + dataSource, (Throwable)e);
            }
        }
    }

    private static DataSource createDataStore(NodeEngine nodeEngine, String externalDataStoreRef) {
        ExternalDataStoreFactory externalDataStoreFactory = nodeEngine.getExternalDataStoreService().getExternalDataStoreFactory(externalDataStoreRef);
        return (DataSource)externalDataStoreFactory.getDataStore();
    }

    private Set<String> readPrimaryKeyColumns(@Nonnull String externalName, Connection connection) {
        HashSet<String> primaryKeyColumns = new HashSet<String>();
        try (ResultSet rs = connection.getMetaData().getPrimaryKeys(null, connection.getSchema(), externalName);){
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                primaryKeyColumns.add(columnName);
            }
        }
        catch (SQLException e) {
            throw new HazelcastException("Could not read primary key columns for table " + externalName, (Throwable)e);
        }
        return primaryKeyColumns;
    }

    private void validateType(MappingField field, DbField dbField) {
        QueryDataType type = this.resolveType(dbField.columnTypeName);
        if (!field.type().equals((Object)type) && !type.getConverter().canConvertTo(field.type().getTypeFamily())) {
            throw new IllegalStateException("type " + field.type().getTypeFamily() + " of field " + field.name() + " does not match db type " + type.getTypeFamily());
        }
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull String externalName, @Nonnull Map<String, String> options, @Nonnull List<MappingField> resolvedFields) {
        ArrayList<TableField> fields = new ArrayList<TableField>(resolvedFields.size());
        for (MappingField resolvedField : resolvedFields) {
            String fieldExternalName = resolvedField.externalName() != null ? resolvedField.externalName() : resolvedField.name();
            fields.add(new JdbcTableField(resolvedField.name(), resolvedField.type(), fieldExternalName, resolvedField.isPrimaryKey()));
        }
        String externalDataStoreRef = options.get(OPTION_EXTERNAL_DATASTORE_REF);
        SqlDialect dialect = this.resolveDialect(nodeEngine, externalDataStoreRef);
        return new JdbcTable(this, fields, dialect, schemaName, mappingName, (TableStatistics)new ConstantTableStatistics(0L), externalName, externalDataStoreRef, Integer.parseInt(options.getOrDefault(OPTION_JDBC_BATCH_LIMIT, JDBC_BATCH_LIMIT_DEFAULT_VALUE)), nodeEngine.getSerializationService());
    }

    /*
     * Exception decompiling
     */
    private SqlDialect resolveDialect(NodeEngine nodeEngine, String externalDataStoreRef) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull DAG dag, @Nonnull Table table0, @Nonnull HazelcastTable hzTable, @Nullable Expression<Boolean> predicate, @Nonnull List<Expression<?>> projection, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        JdbcTable table = (JdbcTable)table0;
        SelectQueryBuilder builder = new SelectQueryBuilder(hzTable);
        return dag.newUniqueVertex("Select (" + table.getExternalName() + ")", ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)new SelectProcessorSupplier(table.getExternalDataStoreRef(), builder.query(), builder.parameterPositions())));
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig insertProcessor(@Nonnull DAG dag, @Nonnull Table table0) {
        JdbcTable table = (JdbcTable)table0;
        InsertQueryBuilder builder = new InsertQueryBuilder(table.getExternalName(), table.dbFieldNames());
        return new SqlConnector.VertexWithInputConfig(dag.newUniqueVertex("Insert (" + table.getExternalName() + ")", (ProcessorSupplier)new InsertProcessorSupplier(table.getExternalDataStoreRef(), builder.query(), table.getBatchLimit())));
    }

    @Override
    @Nonnull
    public List<String> getPrimaryKey(Table table0) {
        JdbcTable table = (JdbcTable)table0;
        return table.getPrimaryKeyList();
    }

    @Override
    @Nonnull
    public Vertex updateProcessor(@Nonnull DAG dag, @Nonnull Table table0, @Nonnull Map<String, RexNode> updates, @Nonnull Map<String, Expression<?>> updatesByFieldNames) {
        JdbcTable table = (JdbcTable)table0;
        List<String> pkFields = this.getPrimaryKey(table0).stream().map(f -> table.getField((String)f).externalName()).collect(Collectors.toList());
        UpdateQueryBuilder builder = new UpdateQueryBuilder(table, pkFields, updates);
        return dag.newUniqueVertex("Update(" + table.getExternalName() + ")", (ProcessorSupplier)new UpdateProcessorSupplier(table.getExternalDataStoreRef(), builder.query(), builder.parameterPositions(), table.getBatchLimit()));
    }

    @Override
    @Nonnull
    public Vertex deleteProcessor(@Nonnull DAG dag, @Nonnull Table table0) {
        JdbcTable table = (JdbcTable)table0;
        List<String> pkFields = this.getPrimaryKey(table0).stream().map(f -> table.getField((String)f).externalName()).collect(Collectors.toList());
        DeleteQueryBuilder builder = new DeleteQueryBuilder(table.getExternalName(), pkFields);
        return dag.newUniqueVertex("Delete(" + table.getExternalName() + ")", (ProcessorSupplier)new DeleteProcessorSupplier(table.getExternalDataStoreRef(), builder.query(), table.getBatchLimit()));
    }

    private QueryDataType resolveType(String columnTypeName) {
        switch (columnTypeName.toUpperCase()) {
            case "BOOLEAN": 
            case "BOOL": 
            case "BIT": {
                return QueryDataType.BOOLEAN;
            }
            case "VARCHAR": 
            case "CHARACTER VARYING": {
                return QueryDataType.VARCHAR;
            }
            case "TINYINT": {
                return QueryDataType.TINYINT;
            }
            case "SMALLINT": 
            case "INT2": {
                return QueryDataType.SMALLINT;
            }
            case "INT": 
            case "INT4": 
            case "INTEGER": {
                return QueryDataType.INT;
            }
            case "INT8": 
            case "BIGINT": {
                return QueryDataType.BIGINT;
            }
            case "DECIMAL": 
            case "NUMERIC": {
                return QueryDataType.DECIMAL;
            }
            case "REAL": 
            case "FLOAT": 
            case "FLOAT4": {
                return QueryDataType.REAL;
            }
            case "DOUBLE": 
            case "DOUBLE PRECISION": 
            case "FLOAT8": {
                return QueryDataType.DOUBLE;
            }
            case "DATE": {
                return QueryDataType.DATE;
            }
            case "TIME": {
                return QueryDataType.TIME;
            }
            case "TIMESTAMP": {
                return QueryDataType.TIMESTAMP;
            }
            case "TIMESTAMP WITH TIME ZONE": {
                return QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME;
            }
        }
        throw new IllegalArgumentException("Unknown column type: " + columnTypeName);
    }

    private static class DbField {
        final String columnTypeName;
        final String columnName;
        final boolean primaryKey;

        DbField(String columnTypeName, String columnName, boolean primaryKey) {
            this.columnTypeName = Objects.requireNonNull(columnTypeName);
            this.columnName = Objects.requireNonNull(columnName);
            this.primaryKey = primaryKey;
        }

        public String toString() {
            return "DbField{columnTypeName='" + this.columnTypeName + '\'' + ", columnName='" + this.columnName + '\'' + ", primaryKey=" + this.primaryKey + '}';
        }
    }
}

