/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.datastore.ExternalDataStoreFactory;
import com.hazelcast.datastore.ExternalDataStoreService;
import com.hazelcast.datastore.impl.CloseableDataSource;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.jet.core.ProcessorSupplier;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;

abstract class AbstractJdbcSqlConnectorProcessorSupplier
implements ProcessorSupplier {
    protected String externalDataStoreRef;
    protected transient DataSource dataSource;

    AbstractJdbcSqlConnectorProcessorSupplier() {
    }

    AbstractJdbcSqlConnectorProcessorSupplier(String externalDataStoreRef) {
        this.externalDataStoreRef = Objects.requireNonNull(externalDataStoreRef, "externalDataStoreRef must not be null");
    }

    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        ExternalDataStoreService externalDataStoreService = ((HazelcastInstanceImpl)context.hazelcastInstance()).node.getNodeEngine().getExternalDataStoreService();
        ExternalDataStoreFactory factory = externalDataStoreService.getExternalDataStoreFactory(this.externalDataStoreRef);
        this.dataSource = (DataSource)factory.getDataStore();
    }

    public void close(@Nullable Throwable error) throws Exception {
        if (this.dataSource instanceof CloseableDataSource) {
            ((CloseableDataSource)this.dataSource).close();
        }
    }
}

